/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.jackson;/*
                                                  * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
                                                  * The software in this package is published under the terms of the CPAL v1.0
                                                  * license, a copy of which has been included with this distribution in the
                                                  * LICENSE.txt file.
                                                  */

import static io.a2a.util.Utils.OBJECT_MAPPER;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;

import org.junit.Test;

public class LLMOutputDeserializerTestCase {

  @Test
  public void simpleInput() throws Exception {
    var json =
        """
            {
              "toolToCall": "it-vendor-sales-broker-talent-pool-mcp-mcp-client-config.TalentPoolMcpServer.match_email_to_address",
              "toolInput": "ankit.jain@example.com",
              "result": "Requested address lookup for ankit.jain@example.com (tool call initiated). Awaiting Talent Pool MCP response containing the employee postal address.",
              "reasoning": "Step 1 of the onboarding process requires obtaining the employee's postal address from the talent pool using the employee email. The TalentPoolMcpServer.match_email_to_address tool is the single appropriate tool to map an email to an address. Input used is the provided employee email. After receiving the address, the next step will be to provision PingID for employeeId 009 using the PingID Agent with input 'employeeId=009&email=ankit.jain@example.com'.",
              "goalComplete": false,
              "additionalInputRequired": true
            }""";

    var output = OBJECT_MAPPER.readValue(json, LLMOutput.class);
    assertThat(output.getToolToCall(),
               equalTo("it-vendor-sales-broker-talent-pool-mcp-mcp-client-config.TalentPoolMcpServer.match_email_to_address"));
    assertThat(output.getToolInput(), equalTo("ankit.jain@example.com"));
    assertThat(output.getResult(),
               equalTo("Requested address lookup for ankit.jain@example.com (tool call initiated). Awaiting Talent Pool MCP response containing the employee postal address."));
    assertThat(output.getReasoning(),
               equalTo("Step 1 of the onboarding process requires obtaining the employee's postal address from the talent pool using the employee email. The TalentPoolMcpServer.match_email_to_address tool is the single appropriate tool to map an email to an address. Input used is the provided employee email. After receiving the address, the next step will be to provision PingID for employeeId 009 using the PingID Agent with input 'employeeId=009&email=ankit.jain@example.com'."));
    assertThat(output.isGoalComplete(), equalTo(false));
    assertThat(output.isAdditionalInputRequired(), equalTo(true));
  }

  @Test
  public void complexInput() throws Exception {
    var json =
        """
            {
              "toolToCall": "it-vendor-sales-broker-talent-pool-mcp-mcp-client-config.TalentPoolMcpServer.match_email_to_address",
              "toolInput": {
                "email": "ankit.jain@example.com"
              },
              "result": "Requested address lookup for ankit.jain@example.com (tool call initiated). Awaiting Talent Pool MCP response containing the employee postal address.",
              "reasoning": "Step 1 of the onboarding process requires obtaining the employee's postal address from the talent pool using the employee email. The TalentPoolMcpServer.match_email_to_address tool is the single appropriate tool to map an email to an address. Input used is the provided employee email. After receiving the address, the next step will be to provision PingID for employeeId 009 using the PingID Agent with input 'employeeId=009&email=ankit.jain@example.com'.",
              "goalComplete": false,
              "additionalInputRequired": true
            }""";

    var output = OBJECT_MAPPER.readValue(json, LLMOutput.class);
    assertThat(output.getToolToCall(),
               equalTo("it-vendor-sales-broker-talent-pool-mcp-mcp-client-config.TalentPoolMcpServer.match_email_to_address"));
    assertThat(output.getToolInput(), equalTo("{\"email\":\"ankit.jain@example.com\"}"));
    assertThat(output.getResult(),
               equalTo("Requested address lookup for ankit.jain@example.com (tool call initiated). Awaiting Talent Pool MCP response containing the employee postal address."));
    assertThat(output.getReasoning(),
               equalTo("Step 1 of the onboarding process requires obtaining the employee's postal address from the talent pool using the employee email. The TalentPoolMcpServer.match_email_to_address tool is the single appropriate tool to map an email to an address. Input used is the provided employee email. After receiving the address, the next step will be to provision PingID for employeeId 009 using the PingID Agent with input 'employeeId=009&email=ankit.jain@example.com'."));
    assertThat(output.isGoalComplete(), equalTo(false));
    assertThat(output.isAdditionalInputRequired(), equalTo(true));
  }
}
