/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.state.model;

import com.mulesoft.modules.agent.broker.internal.state.model.AgentToolContext;
import com.mulesoft.modules.agent.broker.internal.state.model.ConversationState;
import com.mulesoft.modules.agent.broker.internal.state.model.Iteration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String taskId;
    private String conversationId;
    private int currentIteration = 0;
    private List<Iteration> iterations = new ArrayList<Iteration>();
    private ConversationState conversationState = new ConversationState();
    private String conversationHistory = "";
    private Map<String, AgentToolContext> agentToolContexts = new ConcurrentHashMap<String, AgentToolContext>();
    private Set<String> referencedTaskIds = new LinkedHashSet<String>();

    public TaskContext(String taskId, String conversationId) {
        this.taskId = taskId;
        this.conversationId = conversationId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public AgentToolContext getAgentToolContext(String toolName) {
        return this.agentToolContexts.computeIfAbsent(toolName, t -> new AgentToolContext());
    }

    public void addIteration(Iteration iteration) {
        this.iterations.add(iteration);
    }

    public Iteration getLastIteration() {
        if (this.iterations.isEmpty()) {
            Iteration iteration = new Iteration();
            this.addIteration(iteration);
            return iteration;
        }
        return this.iterations.get(this.iterations.size() - 1);
    }

    public List<Iteration> getIterations() {
        return this.iterations;
    }

    public ConversationState getConversationState() {
        return this.conversationState;
    }

    public String getConversationHistory() {
        return this.conversationHistory;
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(int currentIteration) {
        this.currentIteration = currentIteration;
    }

    public void setConversationState(ConversationState conversationState) {
        this.conversationState = conversationState;
    }

    public void setConversationHistory(String conversationHistory) {
        this.conversationHistory = conversationHistory;
    }

    public void refines(TaskContext taskContext) {
        this.setConversationState(taskContext.getConversationState());
        this.setConversationHistory(taskContext.getConversationHistory());
        this.agentToolContexts = new ConcurrentHashMap<String, AgentToolContext>(taskContext.agentToolContexts);
    }

    public Set<String> getReferencedTaskIds() {
        return this.referencedTaskIds;
    }
}

