/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.state.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import io.a2a.util.Utils;
import java.io.IOException;

public class LLMOutputDeserializer
extends StdDeserializer<LLMOutput> {
    public LLMOutputDeserializer() {
        super(LLMOutput.class);
    }

    public LLMOutput deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JacksonException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        return new LLMOutput(this.getString(node, "toolToCall"), this.getString(node, "toolInput"), this.getString(node, "result"), this.getString(node, "reasoning"), this.getBoolean(node, "additionalInputRequired"), this.getBoolean(node, "goalComplete"));
    }

    private String getString(JsonNode node, String fieldName) throws IOException {
        JsonNode fieldNode = node.get(fieldName);
        if (fieldNode == null) {
            return "";
        }
        if (fieldNode.isObject()) {
            return Utils.OBJECT_MAPPER.writeValueAsString((Object)fieldNode);
        }
        return fieldNode.asText();
    }

    public boolean getBoolean(JsonNode node, String fieldName) throws IOException {
        JsonNode fieldNode = node.get(fieldName);
        return fieldNode != null ? fieldNode.asBoolean() : false;
    }
}

