/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public final class ConcurrencyUtils {
    public static <T> void completeAsyncInTCCL(CompletableFuture<T> future, Executor executor, BiConsumer<? super T, ? super Throwable> action) {
        future.whenCompleteAsync((result, error) -> {
            Thread thread = Thread.currentThread();
            ClassLoader originalTccl = thread.getContextClassLoader();
            thread.setContextClassLoader(ConcurrencyUtils.class.getClassLoader());
            try {
                action.accept((Object)result, (Throwable)error);
            }
            finally {
                thread.setContextClassLoader(originalTccl);
            }
        }, executor);
    }

    private ConcurrencyUtils() {
    }
}

