/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.einstein;

import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.einstein.EinsteinSettings;
import com.mulesoft.modules.agent.broker.internal.llm.LLMOrchestrationRequest;
import com.mulesoft.modules.agent.broker.internal.serializer.SerializationService;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameterizer;

public class EinsteinClient
implements LLMClient {
    private static final String EXTENSION_NAME = "Einstein AI";
    private static final String SETTINGS_PARAM_GROUP = "Additional properties";
    private final String configRef;
    private final EinsteinSettings settings;
    private final ExtensionsClient extensionsClient;
    private final SerializationService serializationService;

    public EinsteinClient(String configRef, EinsteinSettings settings, ExtensionsClient extensionsClient, SerializationService serializationService) {
        this.extensionsClient = extensionsClient;
        this.configRef = configRef;
        this.settings = settings;
        this.serializationService = serializationService;
    }

    @Override
    public CompletableFuture<LLMOutput> reasonNextStep(LLMOrchestrationRequest request) {
        return this.extensionsClient.execute(EXTENSION_NAME, "CHAT-answer-prompt", params -> ((OperationParameterizer)((OperationParameterizer)((OperationParameterizer)((OperationParameterizer)params.withConfigRef(this.configRef)).withParameter("General", "prompt", (Object)request.getPrompt())).withParameter(SETTINGS_PARAM_GROUP, "modelApiName", (Object)this.settings.getModelApiName())).withParameter(SETTINGS_PARAM_GROUP, "probability", (Object)this.settings.getProbability())).withParameter(SETTINGS_PARAM_GROUP, "locale", (Object)this.settings.getLocale())).thenApply(result -> this.serializationService.parseEinsteinOutput((InputStream)result.getOutput()));
    }

    @Override
    public void close() {
    }
}

