/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.operation.loop;

import com.mulesoft.modules.agent.broker.api.model.a2a.A2AClient;
import com.mulesoft.modules.agent.broker.api.model.mcp.McpServer;
import com.mulesoft.modules.agent.broker.api.model.tool.CustomToolRoute;
import com.mulesoft.modules.agent.broker.internal.datasense.ToolInputResolver;
import com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes;
import com.mulesoft.modules.agent.broker.internal.extension.AgentsBroker;
import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.operation.loop.Loop;
import com.mulesoft.modules.agent.broker.internal.operation.loop.LoopErrorTypeProvider;
import com.mulesoft.modules.agent.broker.internal.prompt.PromptBuilder;
import com.mulesoft.modules.agent.broker.internal.serializer.SerializationService;
import com.mulesoft.modules.agent.broker.internal.state.ConversationService;
import com.mulesoft.modules.agent.broker.internal.tool.Tool;
import com.mulesoft.modules.agent.broker.internal.tool.ToolRequest;
import com.mulesoft.modules.agent.broker.internal.tool.ToolResponse;
import com.mulesoft.modules.agent.broker.internal.tool.a2a.A2AService;
import com.mulesoft.modules.agent.broker.internal.tool.custom.CustomToolResponse;
import com.mulesoft.modules.agent.broker.internal.tool.mcp.McpService;
import com.mulesoft.modules.agent.broker.internal.tracing.TracingUtils;
import com.mulesoft.modules.agent.broker.internal.util.ExceptionUtils;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendParams;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.sdk.api.annotation.metadata.ChainInputResolver;
import org.mule.sdk.api.annotation.route.ChainExecutionOccurrence;
import org.mule.sdk.api.annotation.route.ExecutionOccurrence;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

public class LoopOperation {
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private SerializationService serializer;
    @Inject
    private McpService mcpService;
    @Inject
    private A2AService a2AService;
    @Inject
    private ConversationService conversationService;

    @Execution(value=ExecutionType.CPU_LITE)
    @Throws(value={LoopErrorTypeProvider.class})
    @MediaType(value="application/json", strict=false)
    public void agentLoop(@Config AgentsBroker config, @Connection LLMClient llmClient, @Optional @Expression(value=ExpressionSupport.REQUIRED) String taskId, @Optional @Expression(value=ExpressionSupport.REQUIRED) String contextId, @Content(primary=true) InputStream a2aMessageSendParams, @Optional String apiInstanceId, @Content String prompt, @Optional @Content String instructions, @Optional @Content String groundings, @ParameterDsl(allowReferences=false) @Optional @NullSafe List<McpServer> mcpServers, @ParameterDsl(allowReferences=false) @Alias(value="a2aClients") @Optional @NullSafe List<A2AClient> a2aClients, @Optional @NullSafe @ExecutionOccurrence(value=ChainExecutionOccurrence.MULTIPLE_OR_NONE) @ChainInputResolver(value=ToolInputResolver.class) List<CustomToolRoute> tools, @ConfigOverride Integer maxNumberOfLoops, @ConfigOverride Integer maxConsecutiveErrors, DistributedTraceContextManager traceContextManager, ExtensionsClient extensionsClient, CompletionCallback<String, Void> completionCallback) {
        Message message;
        TracingUtils.traceBroker(config, apiInstanceId, traceContextManager);
        try {
            message = this.a2AService.unmarshall(a2aMessageSendParams, MessageSendParams.class).message();
        }
        catch (Exception e2) {
            completionCallback.error((Throwable)new ModuleException("Could not parse A2A request", (ErrorTypeDefinition)BrokerErrorTypes.A2A, (Throwable)e2));
            return;
        }
        this.collectTools(tools, mcpServers, a2aClients, extensionsClient).whenComplete((collectedTools, e) -> {
            if (e != null) {
                completionCallback.error(ExceptionUtils.unwrap(e));
                return;
            }
            PromptBuilder promptBuilder = new PromptBuilder(this.expressionManager).setUserPrompt(prompt).setUserInstructions(instructions).setGroundings(groundings).setTools(collectedTools.values()).setMaxLoops(maxNumberOfLoops);
            Loop loop = new Loop(promptBuilder, llmClient, (Map<String, Tool>)collectedTools, taskId, contextId, message, apiInstanceId, maxNumberOfLoops, maxConsecutiveErrors, this.conversationService, this.a2AService, config, extensionsClient, this.schedulerService, completionCallback);
            this.schedulerService.ioScheduler().submit(loop::start);
        });
    }

    private CompletableFuture<Map<String, Tool>> collectTools(List<CustomToolRoute> routeTools, List<McpServer> mcpServers, List<A2AClient> a2aClients, ExtensionsClient extensionsClient) {
        try {
            LinkedHashMap<String, CustomTool> tools = new LinkedHashMap<String, CustomTool>();
            if (routeTools != null) {
                for (CustomToolRoute tool : routeTools) {
                    tools.put(tool.getName(), new CustomTool(tool.getName(), tool.getDescription(), tool.getInput(), tool.getOutput(), tool));
                }
            }
            CompletableFuture<Map<String, Tool>> mcpFuture = this.mcpService.getTools(mcpServers, extensionsClient);
            CompletableFuture<Map<String, Tool>> a2aFuture = this.a2AService.getTools(a2aClients, extensionsClient);
            return mcpFuture.thenCombine(a2aFuture, (mcpTools, a2aTools) -> {
                tools.putAll((Map<String, CustomTool>)mcpTools);
                tools.putAll((Map<String, CustomTool>)a2aTools);
                return tools;
            });
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(ExceptionUtils.unwrap(e));
        }
    }

    private class CustomTool
    extends Tool {
        private final CustomToolRoute toolRoute;

        public CustomTool(String name, String description, String input, String output, CustomToolRoute toolRoute) {
            super(name, name, description, input, output);
            this.toolRoute = toolRoute;
        }

        @Override
        public CompletableFuture<ToolResponse> execute(ToolRequest request, ExtensionsClient extensionsClient) {
            CompletableFuture<ToolResponse> future = new CompletableFuture<ToolResponse>();
            this.toolRoute.getChain().process((Object)request, null, result -> future.complete(new CustomToolResponse(LoopOperation.this.serializer.asString(result))), (t, r) -> future.completeExceptionally((Throwable)t));
            return future;
        }
    }
}

