/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.openai;

import com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes;
import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISettings;
import com.mulesoft.modules.agent.broker.internal.llm.LLMOrchestrationRequest;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import com.openai.models.Reasoning;
import com.openai.models.ReasoningEffort;
import com.openai.models.responses.ResponseCreateParams;
import io.a2a.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class OpenAIClient
implements LLMClient {
    private com.openai.client.OpenAIClient client;
    private final OpenAISettings settings;

    public OpenAIClient(com.openai.client.OpenAIClient client, OpenAISettings settings) {
        this.client = client;
        this.settings = settings;
    }

    @Override
    public CompletableFuture<LLMOutput> reasonNextStep(LLMOrchestrationRequest request) {
        ResponseCreateParams createParams = ResponseCreateParams.builder().input(request.getPrompt()).model(this.settings.getModelName()).reasoning(Reasoning.builder().effort(ReasoningEffort.of((String)this.settings.getReasoningEffort().name().toLowerCase())).build()).additionalHeaders(Map.of("X-ANYPOINT-MODEL", List.of(this.settings.getModelName()))).build();
        return this.client.async().responses().create(createParams).thenApply(response -> response.output().stream().flatMap(item -> item.message().stream()).flatMap(message -> message.content().stream()).flatMap(content -> content.outputText().stream()).findFirst().map(output -> {
            try {
                return (LLMOutput)Utils.OBJECT_MAPPER.readValue(output.text(), LLMOutput.class);
            }
            catch (Exception e) {
                throw new ModuleException("LLM provided unparseable response", (ErrorTypeDefinition)BrokerErrorTypes.REASONING_ERROR, (Throwable)e);
            }
        }).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"LLM provided wrong response format"))));
    }

    @Override
    public void close() {
        this.client.close();
    }
}

