/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.openai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes;
import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISession;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISettings;
import com.mulesoft.modules.agent.broker.internal.llm.LLMRequest;
import com.mulesoft.modules.agent.broker.internal.operation.loop.LoopOperation;
import com.mulesoft.modules.agent.broker.internal.tool.Tool;
import com.mulesoft.modules.agent.broker.internal.tool.ToolVisitor;
import com.mulesoft.modules.agent.broker.internal.tool.a2a.A2AService;
import com.mulesoft.modules.agent.broker.internal.tool.mcp.McpService;
import com.mulesoft.modules.agent.broker.internal.util.ToolUtils;
import com.openai.core.JsonValue;
import com.openai.models.responses.CustomTool;
import com.openai.models.responses.FunctionTool;
import io.a2a.util.Utils;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class OpenAIClient
implements LLMClient {
    private com.openai.client.OpenAIClient client;
    private final OpenAISettings settings;
    private final LoadingCache<Reference<Tool>, com.openai.models.responses.Tool> toolAdapters;

    public OpenAIClient(com.openai.client.OpenAIClient client, OpenAISettings settings) {
        this.client = client;
        this.settings = settings;
        this.toolAdapters = ToolUtils.newToolCache(ref -> this.adapt((Tool)ref.get()), ToolUtils.DEFAULT_TOOL_METADATA_EXPIRY.plusMinutes(1L));
    }

    @Override
    public LLMClient.LLMSession createSession(LLMRequest request) {
        return new OpenAISession(this.client, request, this.settings, this.adapt(request.getTools()));
    }

    @Override
    public void close() {
        this.client.close();
    }

    private List<com.openai.models.responses.Tool> adapt(List<Tool> tools) {
        return tools.stream().map(tool -> (com.openai.models.responses.Tool)this.toolAdapters.get((Object)new Reference(tool))).toList();
    }

    private com.openai.models.responses.Tool adapt(Tool tool) {
        final Reference retVal = new Reference();
        tool.accept(new ToolVisitor(){

            @Override
            public void visit(McpService.McpTool mcpTool) {
                retVal.set((Object)com.openai.models.responses.Tool.ofFunction((FunctionTool)FunctionTool.builder().name(mcpTool.getId()).description(mcpTool.getDescription()).strict(true).parameters(FunctionTool.Parameters.builder().putAllAdditionalProperties(OpenAIClient.this.parseInputSchema(mcpTool)).build()).build()));
            }

            @Override
            public void visit(A2AService.A2ATool tool) {
                retVal.set((Object)com.openai.models.responses.Tool.ofCustom((CustomTool)CustomTool.builder().name(tool.getId()).description("This tool is an external agent. Use a concise natural language prompt clearly stating what is needed from this tool. Only include information relevant for this taskHere's the agent's description: " + tool.getDescription()).build()));
            }

            @Override
            public void visit(LoopOperation.CustomTool tool) {
                throw new UnsupportedOperationException();
            }
        });
        return (com.openai.models.responses.Tool)retVal.get();
    }

    private Map<String, JsonValue> parseInputSchema(McpService.McpTool tool) {
        try {
            ObjectNode schemaRoot = (ObjectNode)Utils.OBJECT_MAPPER.readTree(tool.getInput());
            schemaRoot.set("additionalProperties", (JsonNode)BooleanNode.getFalse());
            schemaRoot.set("required", (JsonNode)this.collectRequiredProperties(schemaRoot));
            return (Map)JsonValue.fromJsonNode((JsonNode)schemaRoot).asObject().get();
        }
        catch (JsonProcessingException e) {
            throw new ModuleException("Supplied schema for MCP tool " + tool.getName() + " is invalid", (ErrorTypeDefinition)BrokerErrorTypes.TOOL_ERROR, (Throwable)e);
        }
    }

    private ArrayNode collectRequiredProperties(ObjectNode root) {
        ArrayNode required = Utils.OBJECT_MAPPER.createArrayNode();
        JsonNode node = root.get("properties");
        if (node == null) {
            return required;
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("'properties' is not an object");
        }
        node.fieldNames().forEachRemaining(arg_0 -> ((ArrayNode)required).add(arg_0));
        return required;
    }
}

