/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.openai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes;
import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISettings;
import com.mulesoft.modules.agent.broker.internal.llm.LLMRequest;
import com.mulesoft.modules.agent.broker.internal.state.model.HasInternalReasoning;
import com.mulesoft.modules.agent.broker.internal.state.model.Iteration;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import com.mulesoft.modules.agent.broker.internal.state.model.ToolSelection;
import com.mulesoft.modules.agent.broker.internal.tool.ToolResponse;
import com.mulesoft.modules.agent.broker.internal.tool.ToolType;
import com.openai.client.OpenAIClient;
import com.openai.models.Reasoning;
import com.openai.models.ReasoningEffort;
import com.openai.models.responses.ResponseCustomToolCall;
import com.openai.models.responses.ResponseCustomToolCallOutput;
import com.openai.models.responses.ResponseFunctionToolCall;
import com.openai.models.responses.ResponseIncludable;
import com.openai.models.responses.ResponseInputItem;
import com.openai.models.responses.ResponseOutputMessage;
import com.openai.models.responses.ResponseOutputText;
import com.openai.models.responses.ResponseReasoningItem;
import com.openai.models.responses.StructuredResponseCreateParams;
import com.openai.models.responses.StructuredResponseOutputItem;
import com.openai.models.responses.StructuredResponseOutputMessage;
import com.openai.models.responses.Tool;
import io.a2a.util.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class OpenAISession
implements LLMClient.LLMSession {
    private final OpenAIClient client;
    private final LLMRequest llmRequest;
    private final List<ResponseInputItem> inputs = new LinkedList<ResponseInputItem>();
    private final OpenAISettings settings;
    private final List<Tool> tools;
    private final StructuredResponseCreateParams.Builder<LLMOutput> builder;

    public OpenAISession(OpenAIClient client, LLMRequest llmRequest, OpenAISettings settings, List<Tool> tools) {
        this.client = client;
        this.llmRequest = llmRequest;
        this.settings = settings;
        this.tools = tools;
        this.builder = this.newRequestBuilder();
    }

    @Override
    public void addIteration(Iteration iteration) {
        ToolSelection toolSelection;
        if (iteration.getUserPrompt() != null) {
            this.inputs.add(ResponseInputItem.ofMessage((ResponseInputItem.Message)ResponseInputItem.Message.builder().role(ResponseInputItem.Message.Role.USER).addInputTextContent(iteration.getUserPrompt()).build()));
        }
        if ((toolSelection = iteration.getToolSelection()) != null) {
            this.addInternalReasoning(toolSelection);
            this.inputs.add(ResponseInputItem.ofFunctionCall((ResponseFunctionToolCall)ResponseFunctionToolCall.builder().callId(toolSelection.getId()).arguments(toolSelection.getInput()).name(toolSelection.getToolName()).build()));
        }
        this.addToolResponse(iteration.getToolResponse());
        LLMOutput llmOutput = iteration.getLlmOutput();
        if (llmOutput != null) {
            this.addInternalReasoning(llmOutput);
            try {
                this.inputs.add(ResponseInputItem.ofResponseOutputMessage((ResponseOutputMessage)ResponseOutputMessage.builder().addContent(ResponseOutputText.builder().text(Utils.OBJECT_MAPPER.writeValueAsString((Object)llmOutput)).build()).build()));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addToolResponse(ToolResponse toolResponse) {
        if (toolResponse != null) {
            if (toolResponse.getToolType() == ToolType.MCP) {
                this.inputs.add(ResponseInputItem.ofFunctionCallOutput((ResponseInputItem.FunctionCallOutput)ResponseInputItem.FunctionCallOutput.builder().outputAsJson((Object)toolResponse.getResult()).callId(toolResponse.getSelection().getId()).status(ResponseInputItem.FunctionCallOutput.Status.COMPLETED).build()));
            } else if (toolResponse.getToolType() == ToolType.A2A) {
                this.inputs.add(ResponseInputItem.ofCustomToolCallOutput((ResponseCustomToolCallOutput)ResponseCustomToolCallOutput.builder().output(toolResponse.getResult()).callId(toolResponse.getSelection().getId()).build()));
            }
        }
    }

    private void addInternalReasoning(HasInternalReasoning reasoned) {
        if (reasoned != null && reasoned.internalReasoning() != null) {
            this.inputs.add(ResponseInputItem.ofReasoning((ResponseReasoningItem)ResponseReasoningItem.builder().encryptedContent(reasoned.internalReasoning()).build()));
        }
    }

    @Override
    public CompletableFuture<Either<LLMOutput, ToolSelection>> getNext() {
        this.builder.inputOfResponse(this.inputs);
        return this.client.async().responses().create(this.builder.build()).thenApply(response -> {
            StringBuilder reasoningBuilder = new StringBuilder();
            for (StructuredResponseOutputItem item : response.output()) {
                ResponseFunctionToolCall toolCall;
                if (item.isReasoning()) {
                    ResponseReasoningItem reasoningItem = item.asReasoning();
                    reasoningItem.encryptedContent().ifPresent(reasoningBuilder::append);
                    this.inputs.add(ResponseInputItem.ofReasoning((ResponseReasoningItem)reasoningItem));
                    continue;
                }
                if (item.isFunctionCall()) {
                    toolCall = item.asFunctionCall();
                    this.inputs.add(ResponseInputItem.ofFunctionCall((ResponseFunctionToolCall)toolCall));
                    return Either.right((Object)new ToolSelection(toolCall.callId(), toolCall.name(), toolCall.arguments(), reasoningBuilder.toString()));
                }
                if (item.isCustomToolCall()) {
                    toolCall = item.asCustomToolCall();
                    this.inputs.add(ResponseInputItem.ofCustomToolCall((ResponseCustomToolCall)toolCall));
                    return Either.right((Object)new ToolSelection(toolCall.callId(), toolCall.name(), toolCall.input(), reasoningBuilder.toString()));
                }
                if (!item.isMessage()) continue;
                StructuredResponseOutputMessage message = item.asMessage();
                this.inputs.add(ResponseInputItem.ofResponseOutputMessage((ResponseOutputMessage)message.rawMessage()));
                LLMOutput output = (LLMOutput)message.content().stream().flatMap(content -> content.outputText().stream()).findFirst().orElseThrow(() -> new ModuleException("LLM provided wrong response format", (ErrorTypeDefinition)BrokerErrorTypes.REASONING_ERROR));
                output.setInternalReasoning(reasoningBuilder.toString());
                return Either.left((Object)output);
            }
            throw new ModuleException("LLM didn't provide a valid response", (ErrorTypeDefinition)BrokerErrorTypes.REASONING_ERROR);
        });
    }

    @Override
    public LLMRequest getInitialRequest() {
        return this.llmRequest;
    }

    private StructuredResponseCreateParams.Builder<LLMOutput> newRequestBuilder() {
        return StructuredResponseCreateParams.builder().instructions(this.buildSystemPrompt(this.llmRequest)).text(LLMOutput.class).model(this.settings.getModelName()).parallelToolCalls(false).store(false).reasoning(Reasoning.builder().effort(ReasoningEffort.of((String)this.settings.getReasoningEffort().name().toLowerCase())).build()).include(List.of(ResponseIncludable.REASONING_ENCRYPTED_CONTENT)).tools(this.tools).additionalHeaders(Map.of("X-ANYPOINT-MODEL", List.of(this.settings.getModelName())));
    }

    private String buildSystemPrompt(LLMRequest request) {
        StringBuilder prompt = new StringBuilder("You are a task decomposition expert that analyzes user requests, identifies required sub-tasks, selects appropriate tools, and synthesizes final answers.\n\n1. **Decompose** the query into atomic sub-tasks\n2. **Match** each sub-task to the appropriate tool below\n3. **Execute** tools in optimal sequence\n4. **Synthesize** results into final response\n\nHere is an Example of how to break down a user prompt\n**User Query:** 'Analyze Q2 earnings for Tesla and compare to Ford in EUR'\n**Sub-tasks:**\n1. Get Tesla financials (USD) \u00e2\u0086\u0092 Financial Summary Tool\n2. Get Ford financials (USD) \u00e2\u0086\u0092 Financial Summary Tool\n3. Convert USD figures to EUR \u00e2\u0086\u0092 Currency Converter Tool\n4. Perform comparative analysis \u00e2\u0086\u0092 Built-in Analysis Module\n\nThe User's instructions section contains directives *YOU MUST* follow when deciding which action to take next.\n\n### User's instructions\n\n").append(request.getInstructions()).append("\n### Instructions for executing steps, selecting tools and generating output\n\n- Execute the list of steps in order. For each step, determine if invoking a tool is necessary\n- When you reach a step that requires a tool, look at the available tools and conversation history to determine the *single best tool* to call next.\n\n### Constraints\n\n- Use the conversation history to avoid redundant tool calls and to track progress toward the goal.\n");
        return prompt.toString();
    }
}

