/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class ToolUtils {
    private static final Pattern TOOL_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private static final Pattern TOOL_NAME_CLEANER = Pattern.compile("[^a-zA-Z0-9_-]");
    public static final Duration DEFAULT_TOOL_METADATA_EXPIRY = Duration.ofHours(1L);

    public static String normalizeToolId(String toolName) {
        if (!TOOL_NAME_PATTERN.matcher(toolName).matches()) {
            toolName = TOOL_NAME_CLEANER.matcher(toolName).replaceAll("_");
        }
        return toolName;
    }

    public static <K, V> Cache<K, V> newToolCache() {
        return ToolUtils.newToolCache(DEFAULT_TOOL_METADATA_EXPIRY);
    }

    public static <K, V> Cache<K, V> newToolCache(Duration expiry) {
        return Caffeine.newBuilder().expireAfterWrite(expiry).build();
    }

    public static <K, V> LoadingCache<K, V> newToolCache(Function<K, V> loader, Duration expiry) {
        return Caffeine.newBuilder().expireAfterWrite(expiry).build(loader::apply);
    }

    private ToolUtils() {
    }
}

