/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection;

import org.mule.runtime.api.functional.Either;

import com.mulesoft.modules.agent.broker.internal.llm.LLMRequest;
import com.mulesoft.modules.agent.broker.internal.state.model.Iteration;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import com.mulesoft.modules.agent.broker.internal.state.model.ToolSelection;
import com.mulesoft.modules.agent.broker.internal.tool.ToolResponse;

import java.util.concurrent.CompletableFuture;

public interface LLMClient {

  interface LLMSession {

    CompletableFuture<Either<LLMOutput, ToolSelection>> getNext();

    LLMRequest getInitialRequest();

    void addIteration(Iteration iteration);

    void addToolResponse(ToolResponse toolResponse);
  }

  LLMSession createSession(LLMRequest request);

  void close();
}
