/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.openai;

import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import com.mulesoft.modules.agent.broker.api.model.llm.openai.OpenAIReasoningEffort;

public class OpenAISettings {

  @Parameter
  private String modelName;

  @Parameter
  @Optional
  private String url;

  @Parameter
  @Password
  private String apiKey;

  @Parameter
  @Optional(defaultValue = "MEDIUM")
  private OpenAIReasoningEffort reasoningEffort;

  /**
   * (0-2), controls the output randomness. Higher = more random outputs. Lower(closer to 0) = more deterministic
   */
  @Parameter
  @Expression(ExpressionSupport.SUPPORTED)
  @Optional(defaultValue = "0.3")
  @Summary("Controls randomness; low is predictable, high is random")
  private Double temperature;

  public String getModelName() {
    return modelName;
  }

  public String getUrl() {
    return url;
  }

  public String getApiKey() {
    return apiKey;
  }

  public OpenAIReasoningEffort getReasoningEffort() {
    return reasoningEffort;
  }

  public Double getTemperature() {
    return temperature;
  }
}
