/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.llm;

import com.mulesoft.modules.agent.broker.internal.tool.Tool;

import java.util.List;

public class LLMRequest {

  private final String prompt;
  private final String instructions;
  private final List<Tool> tools;

  public LLMRequest(String prompt, String instructions, List<Tool> tools) {
    this.prompt = prompt;
    this.instructions = instructions;
    this.tools = tools != null ? tools : List.of();
  }

  public String getPrompt() {
    return prompt;
  }

  public String getInstructions() {
    return instructions;
  }

  public List<Tool> getTools() {
    return tools;
  }
}
