/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.serializer;

import static org.mule.runtime.api.metadata.DataType.STRING;
import static org.mule.runtime.api.metadata.DataType.fromObject;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.runtime.operation.Result;

import javax.inject.Inject;

public class SerializationService implements Initialisable {

  private static final String PAYLOAD = "payload";

  @Inject
  protected ExpressionManager expressionManager;

  private DwConverter toStringReader;

  public <T, A> String asString(Result<T, A> result) {
    return toStringReader.evaluateAsString(result.getOutput(), STRING);
  }

  @Override
  public void initialise() {
    toStringReader = new DwConverter(expressionManager,
                                     """
                                         output application/java
                                         ---
                                         payload as String
                                         """,
                                     (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, fromObject(value))));
  }
}
