/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.state.model;

import java.io.Serializable;

public class AdditionalInputRequired implements Serializable {

  private RequesterType requesterType;
  private int loopNumber;
  private String requesterTool;

  public AdditionalInputRequired(RequesterType requesterType, int loopNumber) {
    this(requesterType, loopNumber, null);
  }

  public AdditionalInputRequired(RequesterType requesterType, int loopNumber, String requesterTool) {
    this.requesterType = requesterType;
    this.loopNumber = loopNumber;
    this.requesterTool = requesterTool;
  }

  public RequesterType getRequesterType() {
    return requesterType;
  }

  public int getLoopNumber() {
    return loopNumber;
  }

  public String getRequesterTool() {
    return requesterTool;
  }

  public enum RequesterType {
    LLM, A2A_TOOL
  }
}
