/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */

package com.mulesoft.modules.agent.broker.internal.state.model;

import static io.a2a.spec.TaskState.UNKNOWN;

import java.io.Serializable;

import io.a2a.spec.TaskState;

public class ConversationState implements Serializable {

  private TaskState taskState;
  private AdditionalInputRequired additionalInputRequired;
  private String errorMessage;

  public ConversationState() {
    this(UNKNOWN, null, null);
  }

  public ConversationState(TaskState taskState) {
    this(taskState, null, null);
  }

  public ConversationState(TaskState taskState, AdditionalInputRequired additionalInputRequired) {
    this(taskState, additionalInputRequired, null);
  }

  public ConversationState(TaskState taskState, String errorMessage) {
    this(taskState, null, errorMessage);
  }

  public ConversationState(TaskState taskState, AdditionalInputRequired additionalInputRequired, String errorMessage) {
    this.taskState = taskState;
    this.additionalInputRequired = additionalInputRequired;
    this.errorMessage = errorMessage;
  }

  public TaskState getTaskState() {
    return taskState;
  }

  public AdditionalInputRequired getAdditionalInputRequired() {
    return additionalInputRequired;
  }

  public String getErrorMessage() {
    return errorMessage;
  }
}
