/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.state.model;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;

public class LLMOutput implements Serializable, HasInternalReasoning {

  @JsonPropertyDescription("Produce a human friendly response summarizing the achieved goal, the reason it failed or the additional input required ")
  private String result;

  @JsonPropertyDescription("Provide clear reasoning explaining why each tool was chosen and how the input was determined, " +
      "or why no tool was selected.")
  private String reasoning;

  @JsonPropertyDescription("If you are not sure what to do next, or if additional input is needed, " +
      "then set this to true and goalComplete to false, and provide appropriate reasoning in the reasoning field")
  private boolean additionalInputRequired;

  @JsonPropertyDescription("If all steps have been completed or the user's goal is already achieved, set this to true. " +
      "**DO NOT** set this to true unless all information requested by the user has been obtained by executing available tools.")
  private boolean goalComplete;

  @JsonPropertyDescription("If the goal cannot be achieved because required tools are missing or failing, " +
      "or you cannot determine what to do next, then set this to true and provide appropriate reasoning in the reasoning field.")
  private boolean goalFailed;

  @JsonIgnore
  private InternalReasoning internalReasoning;

  @JsonIgnore
  private String id;

  @JsonCreator
  public LLMOutput(@JsonProperty("result") String result,
                   @JsonProperty("reasoning") String reasoning,
                   @JsonProperty("additionalInputRequired") boolean additionalInputRequired,
                   @JsonProperty("goalComplete") boolean goalComplete,
                   @JsonProperty("goalFailed") boolean goalFailed) {
    this.result = result;
    this.reasoning = reasoning;
    this.additionalInputRequired = additionalInputRequired;
    this.goalComplete = goalComplete;
    this.goalFailed = goalFailed;
  }

  public String getResult() {
    return result;
  }

  public String getReasoning() {
    return reasoning;
  }

  public boolean isAdditionalInputRequired() {
    return additionalInputRequired;
  }

  public boolean isGoalComplete() {
    return goalComplete;
  }

  public boolean isGoalFailed() {
    return goalFailed;
  }

  @Override
  public InternalReasoning getInternalReasoning() {
    return internalReasoning;
  }

  public void setInternalReasoning(InternalReasoning internalReasoning) {
    this.internalReasoning = internalReasoning;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }
}
