/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */

package com.mulesoft.modules.agent.broker.internal.state.model;

import static java.util.Collections.unmodifiableList;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskContext implements Serializable {

  private static final long serialVersionUID = 1L;

  private String taskId;
  private String conversationId;
  private List<Iteration> iterations = new ArrayList<>();
  private ConversationState conversationState = new ConversationState();
  private Map<String, AgentToolContext> agentToolContexts = new ConcurrentHashMap<>();
  private Set<String> referencedTaskIds = new LinkedHashSet<>();

  public TaskContext(String taskId, String conversationId) {
    this.taskId = taskId;
    this.conversationId = conversationId;
  }

  public String getConversationId() {
    return conversationId;
  }

  public String getTaskId() {
    return taskId;
  }

  public AgentToolContext getAgentToolContext(String toolName) {
    return agentToolContexts.computeIfAbsent(toolName, t -> new AgentToolContext());
  }

  public Iteration newIteration() {
    var iteration = new Iteration(iterations.size() + 1);
    iterations.add(iteration);

    return iteration;
  }

  public List<Iteration> getIterations() {
    return unmodifiableList(iterations);
  }

  public Iteration getLastIteration() {
    if (iterations.isEmpty()) {
      throw new NoSuchElementException();
    } else {
      return iterations.get(iterations.size() - 1);
    }
  }

  public ConversationState getConversationState() {
    return conversationState;
  }

  public void setConversationState(ConversationState conversationState) {
    this.conversationState = conversationState;
  }

  public TaskContext createContinuation(String newTaskId) {
    TaskContext newTask = new TaskContext(newTaskId, conversationId);
    newTask.iterations.addAll(iterations);
    newTask.referencedTaskIds.addAll(referencedTaskIds);

    return newTask;
  }

  public Set<String> getReferencedTaskIds() {
    return referencedTaskIds;
  }
}
