/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.state.model;

import java.io.Serializable;

public final class ToolSelection implements Serializable, HasInternalReasoning {

  private final String selectionId;
  private final String toolId;
  private String input;
  private final InternalReasoning internalReasoning;

  public ToolSelection(
                       String selectionId,
                       String toolId,
                       String input,
                       InternalReasoning internalReasoning) {
    this.selectionId = selectionId;
    this.toolId = toolId;
    this.input = input;
    this.internalReasoning = internalReasoning;
  }

  public String getSelectionId() {
    return selectionId;
  }

  public String getToolId() {
    return toolId;
  }

  public String getInput() {
    return input;
  }

  public void setInput(String input) {
    this.input = input;
  }

  @Override
  public InternalReasoning getInternalReasoning() {
    return internalReasoning;
  }
}
