/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.tool;

import com.mulesoft.modules.agent.broker.internal.state.model.ToolSelection;

import java.io.Serializable;

public class ToolResponse implements Serializable {

  private final String result;
  private final ToolSelection selection;
  private final ToolType toolType;

  public ToolResponse(String result, ToolSelection selection, ToolType toolType) {
    this.result = result;
    this.selection = selection;
    this.toolType = toolType;
  }

  public final String getResult() {
    return result;
  }

  public ToolSelection getSelection() {
    return selection;
  }

  public final ToolType getToolType() {
    return toolType;
  }
}
