/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.tool.a2a;

import static com.mulesoft.modules.agent.broker.internal.tool.ToolType.A2A;

import com.mulesoft.modules.agent.broker.internal.state.model.ToolSelection;
import com.mulesoft.modules.agent.broker.internal.tool.ToolResponse;

import java.util.List;

import io.a2a.spec.Artifact;
import io.a2a.spec.Part;
import io.a2a.spec.TaskState;

public final class A2AToolResponse extends ToolResponse {

  private final String taskId;
  private final String contextId;
  private final TaskState state;
  private transient final List<Artifact> artifacts;
  private transient final List<Part<?>> messageParts;

  public A2AToolResponse(String result,
                         ToolSelection selection,
                         String taskId,
                         String contextId,
                         TaskState state,
                         List<Part<?>> messageParts,
                         List<Artifact> artifacts) {
    super(result, selection, A2A);
    this.taskId = taskId;
    this.contextId = contextId;
    this.state = state;
    this.messageParts = messageParts;
    this.artifacts = artifacts;
  }

  public boolean isInputRequired() {
    return state == TaskState.INPUT_REQUIRED;
  }

  public String getTaskId() {
    return taskId;
  }

  public TaskState getState() {
    return state;
  }

  public String getContextId() {
    return contextId;
  }

  public List<Artifact> getArtifacts() {
    return artifacts != null ? artifacts : List.of();
  }

  public List<Part<?>> getMessageParts() {
    return messageParts != null ? messageParts : List.of();
  }
}
