/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.tool.a2a;

import static java.util.stream.Collectors.joining;

import java.util.List;

import io.a2a.spec.Message;
import io.a2a.spec.Part;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TextPart;

public final class A2AUtils {

  private A2AUtils() {}

  public static List<Part<?>> collectParts(TaskStatus status) {
    return status != null ? collectParts(status.message()) : List.of();
  }

  public static List<Part<?>> collectParts(Message message) {
    if (message == null || message.getParts() == null || message.getParts().isEmpty()) {
      return List.of();
    }

    return message.getParts();
  }

  public static String joinTextParts(Message message) {
    return collectParts(message).stream()
        .filter(part -> part instanceof TextPart)
        .map(part -> ((TextPart) part).getText())
        .collect(joining("\n"));
  }
}
