/*
 * (c) 2025 MuleSoft, Inc. The software in this package is published under the terms of the Commercial Free Software license V.1 a copy of which has been included with this distribution in the LICENSE.md file.
 */
package com.mulesoft.modules.agent.broker.internal.util;

import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

import java.util.concurrent.CompletionException;

public class ExceptionUtils {

  public static Throwable unwrap(Throwable t) {
    if (t instanceof CompletionException) {
      t = t.getCause();
    }

    return org.mule.runtime.core.api.util.ExceptionUtils.getMessagingExceptionCause(t);
  }

  public static ModuleException asModuleException(Throwable t, ErrorTypeDefinition type) {
    if (t instanceof ModuleException) {
      return (ModuleException) t;
    }

    return new ModuleException(t.getMessage(), type, t);
  }
}
