/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.state.model;

import com.mulesoft.modules.agent.broker.internal.state.model.AgentToolContext;
import com.mulesoft.modules.agent.broker.internal.state.model.ConversationState;
import com.mulesoft.modules.agent.broker.internal.state.model.Iteration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String taskId;
    private String conversationId;
    private List<Iteration> iterations = new ArrayList<Iteration>();
    private ConversationState conversationState = new ConversationState();
    private Map<String, AgentToolContext> agentToolContexts = new ConcurrentHashMap<String, AgentToolContext>();
    private Set<String> referencedTaskIds = new LinkedHashSet<String>();

    public TaskContext(String taskId, String conversationId) {
        this.taskId = taskId;
        this.conversationId = conversationId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public AgentToolContext getAgentToolContext(String toolName) {
        return this.agentToolContexts.computeIfAbsent(toolName, t -> new AgentToolContext());
    }

    public Iteration newIteration() {
        Iteration iteration = new Iteration(this.iterations.size() + 1);
        this.iterations.add(iteration);
        return iteration;
    }

    public List<Iteration> getIterations() {
        return Collections.unmodifiableList(this.iterations);
    }

    public Iteration getLastIteration() {
        if (this.iterations.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.iterations.get(this.iterations.size() - 1);
    }

    public ConversationState getConversationState() {
        return this.conversationState;
    }

    public void setConversationState(ConversationState conversationState) {
        this.conversationState = conversationState;
    }

    public TaskContext createContinuation(String newTaskId) {
        TaskContext newTask = new TaskContext(newTaskId, this.conversationId);
        newTask.iterations.addAll(this.iterations);
        newTask.referencedTaskIds.addAll(this.referencedTaskIds);
        return newTask;
    }

    public Set<String> getReferencedTaskIds() {
        return this.referencedTaskIds;
    }
}

