/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.tracing;

import com.mulesoft.modules.agent.broker.internal.extension.AgentsBroker;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

public final class TracingUtils {
    private static final String ARTIFACT_TYPE = "artifact.type";
    private static final String AGENT_NAME = "agent.name";
    private static final String AGENT_BROKER = "agent/broker";
    private static final String API_INSTANCE_ID = "mulesoft.api.instance.id";

    private TracingUtils() {
    }

    public static void traceBroker(AgentsBroker agent, String apiInstanceId, DistributedTraceContextManager contextManager) {
        contextManager.setCurrentSpanName("[BROKER] " + agent.getConfigName());
        contextManager.addCurrentSpanAttribute(ARTIFACT_TYPE, AGENT_BROKER);
        contextManager.addCurrentSpanAttribute(AGENT_NAME, agent.getConfigName());
        if (apiInstanceId != null) {
            contextManager.addCurrentSpanAttribute(API_INSTANCE_ID, apiInstanceId);
        }
    }
}

