/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.session;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes;
import com.mulesoft.modules.agent.broker.internal.extension.connection.LLMClient;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISettings;
import com.mulesoft.modules.agent.broker.internal.llm.LLMRequest;
import com.mulesoft.modules.agent.broker.internal.state.model.HasInternalReasoning;
import com.mulesoft.modules.agent.broker.internal.state.model.InternalReasoning;
import com.mulesoft.modules.agent.broker.internal.state.model.Iteration;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import com.mulesoft.modules.agent.broker.internal.state.model.ToolSelection;
import com.mulesoft.modules.agent.broker.internal.tool.ToolResponse;
import com.mulesoft.modules.agent.broker.internal.tool.ToolType;
import com.openai.client.OpenAIClient;
import com.openai.core.JsonString;
import com.openai.core.JsonValue;
import com.openai.models.Reasoning;
import com.openai.models.ReasoningEffort;
import com.openai.models.responses.ResponseCreateParams;
import com.openai.models.responses.ResponseCustomToolCall;
import com.openai.models.responses.ResponseCustomToolCallOutput;
import com.openai.models.responses.ResponseFunctionToolCall;
import com.openai.models.responses.ResponseIncludable;
import com.openai.models.responses.ResponseInputItem;
import com.openai.models.responses.ResponseOutputMessage;
import com.openai.models.responses.ResponseOutputText;
import com.openai.models.responses.ResponseReasoningItem;
import com.openai.models.responses.Tool;
import io.a2a.util.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public abstract class BaseLLMSession
implements LLMClient.LLMSession {
    private final LLMRequest llmRequest;
    private final OpenAISettings settings;
    private final List<Tool> tools;
    protected final ResponseCreateParams.Builder builder;
    protected final List<ResponseInputItem> inputs = new LinkedList<ResponseInputItem>();
    protected final OpenAIClient client;
    protected InternalReasoning internalReasoning;

    public BaseLLMSession(OpenAIClient client, LLMRequest llmRequest, OpenAISettings settings, List<Tool> tools) {
        this.client = client;
        this.llmRequest = llmRequest;
        this.settings = settings;
        this.tools = tools;
        this.builder = this.newRequestBuilder();
    }

    @Override
    public void addIteration(Iteration iteration) {
        ToolSelection toolSelection;
        if (iteration.getUserPrompt() != null) {
            this.inputs.add(ResponseInputItem.ofMessage((ResponseInputItem.Message)ResponseInputItem.Message.builder().role(ResponseInputItem.Message.Role.USER).addInputTextContent(iteration.getUserPrompt()).build()));
        }
        if ((toolSelection = iteration.getToolSelection()) != null) {
            this.addInternalReasoning(toolSelection);
            this.inputs.add(ResponseInputItem.ofFunctionCall((ResponseFunctionToolCall)ResponseFunctionToolCall.builder().callId(toolSelection.getSelectionId()).arguments(toolSelection.getInput()).name(toolSelection.getToolId()).build()));
        }
        this.addToolResponse(iteration.getToolResponse());
        LLMOutput llmOutput = iteration.getLlmOutput();
        if (llmOutput != null) {
            this.addInternalReasoning(llmOutput);
            try {
                this.inputs.add(ResponseInputItem.ofResponseOutputMessage((ResponseOutputMessage)ResponseOutputMessage.builder().id(llmOutput.getId()).role((JsonValue)JsonString.of((String)"assistant")).status(ResponseOutputMessage.Status.COMPLETED).addContent(ResponseOutputText.builder().text(Utils.OBJECT_MAPPER.writeValueAsString((Object)llmOutput)).annotations(List.of()).build()).build()));
            }
            catch (JsonProcessingException e) {
                throw new ModuleException("Exception serializing response output", (ErrorTypeDefinition)BrokerErrorTypes.LLM_ERROR, (Throwable)e);
            }
        }
    }

    @Override
    public void addToolResponse(ToolResponse toolResponse) {
        if (toolResponse != null) {
            if (toolResponse.getToolType() == ToolType.MCP) {
                this.inputs.add(ResponseInputItem.ofFunctionCallOutput((ResponseInputItem.FunctionCallOutput)ResponseInputItem.FunctionCallOutput.builder().outputAsJson((Object)toolResponse.getResult()).callId(toolResponse.getSelection().getSelectionId()).status(ResponseInputItem.FunctionCallOutput.Status.COMPLETED).build()));
            } else if (toolResponse.getToolType() == ToolType.A2A) {
                this.inputs.add(ResponseInputItem.ofCustomToolCallOutput((ResponseCustomToolCallOutput)ResponseCustomToolCallOutput.builder().output(toolResponse.getResult()).callId(toolResponse.getSelection().getSelectionId()).build()));
            }
        }
    }

    private void addInternalReasoning(HasInternalReasoning reasoned) {
        InternalReasoning internalReasoning;
        InternalReasoning internalReasoning2 = internalReasoning = reasoned != null ? reasoned.getInternalReasoning() : null;
        if (internalReasoning != null) {
            this.inputs.add(ResponseInputItem.ofReasoning((ResponseReasoningItem)ResponseReasoningItem.builder().id(internalReasoning.getId()).encryptedContent(internalReasoning.getReasoning()).summary(List.of()).build()));
        }
    }

    protected abstract CompletableFuture<Either<LLMOutput, ToolSelection>> doGetNext();

    @Override
    public final CompletableFuture<Either<LLMOutput, ToolSelection>> getNext() {
        this.builder.inputOfResponse(this.inputs);
        return this.doGetNext();
    }

    protected Either<LLMOutput, ToolSelection> onCustomCall(ResponseCustomToolCall toolCall) {
        this.inputs.add(ResponseInputItem.ofCustomToolCall((ResponseCustomToolCall)toolCall));
        return Either.right((Object)new ToolSelection(toolCall.callId(), toolCall.name(), toolCall.input(), this.internalReasoning));
    }

    protected Either<LLMOutput, ToolSelection> onFunctionCall(ResponseFunctionToolCall toolCall) {
        this.inputs.add(ResponseInputItem.ofFunctionCall((ResponseFunctionToolCall)toolCall));
        return Either.right((Object)new ToolSelection(toolCall.callId(), toolCall.name(), toolCall.arguments(), this.internalReasoning));
    }

    protected void onReasoningItem(ResponseReasoningItem reasoningItem) {
        this.inputs.add(ResponseInputItem.ofReasoning((ResponseReasoningItem)reasoningItem));
        this.internalReasoning = new InternalReasoning(reasoningItem.id(), reasoningItem.encryptedContent().orElse(""));
    }

    @Override
    public LLMRequest getInitialRequest() {
        return this.llmRequest;
    }

    protected ResponseCreateParams.Builder newRequestBuilder() {
        return ResponseCreateParams.builder().instructions(this.buildSystemPrompt(this.llmRequest)).model(this.settings.getModelName()).parallelToolCalls(false).store(false).reasoning(Reasoning.builder().effort(ReasoningEffort.of((String)this.settings.getReasoningEffort().name().toLowerCase())).build()).include(List.of(ResponseIncludable.REASONING_ENCRYPTED_CONTENT)).tools(this.tools).additionalHeaders(Map.of("X-ANYPOINT-MODEL", List.of(this.settings.getModelName())));
    }

    private String buildSystemPrompt(LLMRequest request) {
        StringBuilder prompt = new StringBuilder("You are a task decomposition expert that analyzes user requests, identifies required sub-tasks, selects appropriate tools, and synthesizes final answers.\n\n1. **Decompose** the query into atomic sub-tasks\n2. **Match** each sub-task to the appropriate tool below\n3. **Execute** tools in optimal sequence\n4. **Synthesize** results into final response\n\nHere is an Example of how to break down a user prompt\n**User Query:** 'Analyze Q2 earnings for Tesla and compare to Ford in EUR'\n**Sub-tasks:**\n1. Get Tesla financials (USD) \u00e2\u0086\u0092 Financial Summary Tool\n2. Get Ford financials (USD) \u00e2\u0086\u0092 Financial Summary Tool\n3. Convert USD figures to EUR \u00e2\u0086\u0092 Currency Converter Tool\n4. Perform comparative analysis \u00e2\u0086\u0092 Built-in Analysis Module\n\nThe User's instructions section contains directives *YOU MUST* follow when deciding which action to take next.\n\n### User's instructions\n\n").append(request.getInstructions()).append("\n### Instructions for executing steps, selecting tools and generating output\n\n- Execute the list of steps in order. For each step, determine if invoking a tool is necessary\n- When you reach a step that requires a tool, look at the available tools and conversation history to determine the *single best tool* to call next.\n\n### Constraints\n\n- Use the conversation history to avoid redundant tool calls and to track progress toward the goal.\n");
        return prompt.toString();
    }
}

