/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.extension.connection.session;

import com.mulesoft.modules.agent.broker.internal.error.BrokerErrorTypes;
import com.mulesoft.modules.agent.broker.internal.extension.connection.openai.OpenAISettings;
import com.mulesoft.modules.agent.broker.internal.extension.connection.session.BaseLLMSession;
import com.mulesoft.modules.agent.broker.internal.llm.LLMRequest;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import com.mulesoft.modules.agent.broker.internal.state.model.ToolSelection;
import com.openai.client.OpenAIClient;
import com.openai.models.responses.ResponseCreateParams;
import com.openai.models.responses.ResponseInputItem;
import com.openai.models.responses.ResponseOutputMessage;
import com.openai.models.responses.StructuredResponseCreateParams;
import com.openai.models.responses.StructuredResponseOutputItem;
import com.openai.models.responses.StructuredResponseOutputMessage;
import com.openai.models.responses.Tool;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class StructuredResponseSession
extends BaseLLMSession {
    private StructuredResponseCreateParams.Builder<LLMOutput> structuredBuilder;

    public StructuredResponseSession(OpenAIClient client, LLMRequest llmRequest, OpenAISettings settings, List<Tool> tools) {
        super(client, llmRequest, settings, tools);
    }

    @Override
    protected ResponseCreateParams.Builder newRequestBuilder() {
        ResponseCreateParams.Builder builder = super.newRequestBuilder();
        this.structuredBuilder = builder.text(LLMOutput.class);
        return builder;
    }

    @Override
    protected CompletableFuture<Either<LLMOutput, ToolSelection>> doGetNext() {
        return this.client.async().responses().create(this.structuredBuilder.build()).thenApply(response -> {
            for (StructuredResponseOutputItem item : response.output()) {
                if (item.isReasoning()) {
                    this.onReasoningItem(item.asReasoning());
                    continue;
                }
                if (item.isFunctionCall()) {
                    return this.onFunctionCall(item.asFunctionCall());
                }
                if (item.isCustomToolCall()) {
                    return this.onCustomCall(item.asCustomToolCall());
                }
                if (!item.isMessage()) continue;
                StructuredResponseOutputMessage message = item.asMessage();
                this.inputs.add(ResponseInputItem.ofResponseOutputMessage((ResponseOutputMessage)message.rawMessage()));
                LLMOutput output = (LLMOutput)message.content().stream().flatMap(content -> content.outputText().stream()).findFirst().orElseThrow(() -> new ModuleException("LLM provided wrong response format", (ErrorTypeDefinition)BrokerErrorTypes.REASONING_ERROR));
                output.setInternalReasoning(this.internalReasoning);
                output.setId(message.rawMessage().id());
                return Either.left((Object)output);
            }
            throw new ModuleException("LLM didn't provide a valid response", (ErrorTypeDefinition)BrokerErrorTypes.REASONING_ERROR);
        });
    }
}

