/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.agent.broker.internal.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.mulesoft.modules.agent.broker.internal.state.model.LLMOutput;
import com.openai.core.JsonValue;
import io.a2a.util.Utils;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.text.RandomStringGenerator;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.StringUtils;

public final class ToolUtils {
    public static final Duration DEFAULT_TOOL_METADATA_EXPIRY = Duration.ofHours(1L);
    static final int MAX_TOOL_ID_LENGTH = 50;
    private static final Pattern TOOL_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private static final Pattern TOOL_NAME_CLEANER = Pattern.compile("[^a-zA-Z0-9_-]");
    private static final String BASE62_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final RandomStringGenerator TOOL_CALL_ID_GENERATOR = RandomStringGenerator.builder().selectFrom("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray()).get();

    public static String generateToolId(String configName, String toolName) {
        String hash;
        Object id;
        if (StringUtils.isBlank((String)toolName)) {
            throw new IllegalArgumentException("tool name cannot be blank");
        }
        if (!TOOL_NAME_PATTERN.matcher(toolName).matches()) {
            toolName = TOOL_NAME_CLEANER.matcher(toolName).replaceAll("_");
        }
        if (((String)(id = (hash = ToolUtils.generateHash(configName + "." + toolName)) + "_" + toolName)).length() > 50) {
            id = ((String)id).substring(0, 50);
        }
        return id;
    }

    public static <K, V> Cache<K, V> newToolCache() {
        return ToolUtils.newToolCache(DEFAULT_TOOL_METADATA_EXPIRY);
    }

    public static <K, V> Cache<K, V> newToolCache(Duration expiry) {
        return Caffeine.newBuilder().expireAfterWrite(expiry).build();
    }

    public static String randomToolCallId() {
        return "call_" + ToolUtils.randomString(24);
    }

    public static String randomString(int length) {
        return TOOL_CALL_ID_GENERATOR.generate(length);
    }

    public static <K, V> LoadingCache<K, V> newToolCache(Function<K, V> loader, Duration expiry) {
        return Caffeine.newBuilder().expireAfterWrite(expiry).build(loader::apply);
    }

    private static String generateHash(String input) {
        long hash1 = -3750763034362895579L;
        long hash2 = 0L;
        long prime = 31L;
        long mod = 1000000000000L;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            hash1 ^= (long)c;
            hash1 *= 1099511628211L;
            hash2 = (hash2 * prime + (long)c) % mod;
        }
        long combined = hash1 ^ hash2 << 32 ^ hash2 >>> 32;
        combined ^= combined >>> 33;
        combined *= -49064778989728563L;
        combined ^= combined >>> 33;
        combined *= -4265267296055464877L;
        combined ^= combined >>> 33;
        return ToolUtils.toBase62(Math.abs(combined), 10);
    }

    private static String toBase62(long num, int length) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length) {
            sb.append(BASE62_CHARS.charAt((int)(num % 62L)));
            num /= 62L;
        }
        return sb.reverse().toString();
    }

    public static Map<String, JsonValue> openAiLLMOutputSchema() {
        try {
            ObjectNode schema = (ObjectNode)Utils.OBJECT_MAPPER.valueToTree((Object)new JsonSchemaGenerator(Utils.OBJECT_MAPPER).generateSchema(LLMOutput.class));
            schema.put("$schema", "http://json-schema.org/draft-07/schema#");
            schema.put("description", "Schema for a n LLM structured answer");
            return ToolUtils.toOpenAiToolSchema(schema);
        }
        catch (JsonProcessingException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unable to generate schema for a n LLM structured answer"), (Throwable)e);
        }
    }

    public static Map<String, JsonValue> toOpenAiToolSchema(String schema) throws JsonProcessingException {
        return ToolUtils.toOpenAiToolSchema((ObjectNode)Utils.OBJECT_MAPPER.readTree(schema));
    }

    public static Map<String, JsonValue> toOpenAiToolSchema(ObjectNode schemaRoot) throws JsonProcessingException {
        schemaRoot.set("additionalProperties", (JsonNode)BooleanNode.getFalse());
        schemaRoot.set("required", (JsonNode)ToolUtils.collectRequiredProperties(schemaRoot));
        return (Map)JsonValue.fromJsonNode((JsonNode)schemaRoot).asObject().get();
    }

    private static ArrayNode collectRequiredProperties(ObjectNode root) {
        ArrayNode required = Utils.OBJECT_MAPPER.createArrayNode();
        JsonNode node = root.get("properties");
        if (node == null) {
            return required;
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("'properties' is not an object");
        }
        node.fieldNames().forEachRemaining(arg_0 -> ((ArrayNode)required).add(arg_0));
        return required;
    }

    private ToolUtils() {
    }
}

