/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.modules.interceptor.matchers;

/**
 * <p>
 * Matcher to check null
 * </p>
 * <p/>
 * Usage: <code>new NullMatcher().match(null)</code> will return true
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class NullMatcher implements Matcher
{

    /**
     * @see Matcher#match(Object)
     */
    @Override
    public boolean match(Object o)
    {
        return o == null;
    }
}
