/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.interceptor.processors;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.NamedObject;
import org.mule.api.construct.FlowConstruct;
import org.mule.modules.interceptor.matchers.Matcher;
import org.mule.modules.interceptor.processors.MessageProcessorId;

public class MessageProcessorCall {
    private MessageProcessorId messageProcessorId;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private FlowConstruct flowConstruct;

    public MessageProcessorCall(MessageProcessorId messageProcessorId) {
        this.messageProcessorId = messageProcessorId;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public MessageProcessorId getMessageProcessorId() {
        return this.messageProcessorId;
    }

    public boolean isCallOf(MessageProcessorId id) {
        return this.messageProcessorId.equals(id);
    }

    public int matchingWeight(MessageProcessorCall call) {
        if (this.messageProcessorId.getFullName().equals(call.getMessageProcessorId().getFullName()) || call.getMessageProcessorId().getName().matches(this.messageProcessorId.getName()) && call.getMessageProcessorId().getNamespace().matches(this.messageProcessorId.getNamespace())) {
            Map<String, Object> callAttributes = call.getAttributes();
            for (Map.Entry<String, Object> myAttribute : this.attributes.entrySet()) {
                if (this.callHasAttribute(callAttributes, myAttribute)) continue;
                return -1;
            }
            return this.attributes.size();
        }
        return -1;
    }

    private boolean callHasAttribute(Map<String, Object> callAttributes, Map.Entry<String, Object> myAttribute) {
        String myAttributeKey = myAttribute.getKey();
        return callAttributes.containsKey(myAttributeKey) && (this.matchAttributeValue(callAttributes.get(myAttributeKey), myAttribute.getValue()) || this.matchAttributeName(callAttributes.get(myAttributeKey), myAttribute.getValue()));
    }

    private boolean matchAttributeValue(Object value, Object matcher) {
        if (matcher == null) {
            return value == null;
        }
        if (matcher instanceof Matcher) {
            return ((Matcher)matcher).match(value);
        }
        return matcher.equals(value);
    }

    private boolean matchAttributeName(Object value, Object matcher) {
        if (value instanceof NamedObject) {
            return this.matchAttributeValue(((NamedObject)value).getName(), matcher);
        }
        return false;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }
}

