/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.interceptor.processors;

import java.util.Map;

public class MessageProcessorId {
    private String name;
    private String namespace;

    public static String getNamespace(String fullName) {
        String[] split = fullName.split(":");
        if (split.length > 1) {
            return split[0];
        }
        return "mule";
    }

    public static String getName(String fullName) {
        String[] split = fullName.split(":");
        if (split.length > 1) {
            return split[1];
        }
        return split[0];
    }

    public MessageProcessorId(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public MessageProcessorId(String name, String namespace, Map<String, Object> attributes) {
        this.name = name;
        this.namespace = namespace;
    }

    public String getFullName() {
        return this.namespace + ":" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean equals(Object o) {
        if (o instanceof MessageProcessorId) {
            MessageProcessorId mpId = (MessageProcessorId)o;
            return mpId.getName().equals(this.name) && mpId.getNamespace().equals(this.namespace);
        }
        return false;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }
}

