/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.interceptor.processors;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.modules.interceptor.processors.MessageProcessorBehavior;
import org.mule.modules.interceptor.processors.MessageProcessorCall;
import org.mule.modules.interceptor.processors.MessageProcessorCallAction;

public class MessageProcessorManager {
    public static String ID = "_muleMpManager";
    protected List<MessageProcessorBehavior> behaviors = new ArrayList<MessageProcessorBehavior>();

    public void reset() {
        this.behaviors.clear();
    }

    public MessageProcessorBehavior getBetterMatchingBehavior(MessageProcessorCall messageProcessorCall) {
        return this.getBetterMatchingAction(messageProcessorCall, this.behaviors);
    }

    protected <T extends MessageProcessorCallAction> T getBetterMatchingAction(MessageProcessorCall messageProcessorCall, Collection<T> actions) {
        AbstractMap.SimpleEntry<Integer, Object> bestMatchingBehavior = new AbstractMap.SimpleEntry<Integer, Object>(0, null);
        for (MessageProcessorCallAction behavior : actions) {
            int matchingWeight = behavior.getMessageProcessorCall().matchingWeight(messageProcessorCall);
            if (matchingWeight < 0 || matchingWeight < (Integer)bestMatchingBehavior.getKey()) continue;
            bestMatchingBehavior.setValue(behavior);
        }
        return (T)((MessageProcessorCallAction)bestMatchingBehavior.getValue());
    }

    public synchronized void addBehavior(MessageProcessorBehavior behavior) {
        this.behaviors.add(behavior);
    }
}

