/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.modules.interceptor.processors;

/**
 * <p>
 * The representation of a Message Processor mocked behavior.
 * We use this in order to know that the Message processor must return.
 * </p>
 *
 * @author Mulesoft Inc.
 * @since  3.3.2
 */
public class MessageProcessorBehavior extends MessageProcessorCallAction
{

    /**
     * <p>
     * The message processor call representation. When this call is executed then return returnMessage
     * </p>
     */
    private MessageProcessorCall messageProcessorCall;

    /**
     * <p>
     * The {@link MuleMessageTransformer} that will change the {@link org.mule.api.MuleMessage} of the message processor
     * </p>
     */
    private MuleMessageTransformer muleMessageTransformer;

    /**
     * <p>
     * The exception that has to be thrown when this behavior is executed
     * </p>
     */
    private Throwable exceptionToThrow;

    public MessageProcessorBehavior(MessageProcessorCall messageProcessorCall, MuleMessageTransformer muleMessageTransformer)
    {
        super(messageProcessorCall);
        this.muleMessageTransformer = muleMessageTransformer;
    }

    public MessageProcessorBehavior(MessageProcessorCall messageProcessorCall, Throwable exceptionToThrow)
    {
        super(messageProcessorCall);
        this.exceptionToThrow = exceptionToThrow;
    }

    public MuleMessageTransformer getMuleMessageTransformer()
    {
        return muleMessageTransformer;
    }



    public Throwable getExceptionToThrow()
    {
        return exceptionToThrow;
    }
}
