/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.modules.interceptor.matchers;

/**
 * <p>
 * Dumb matcher that returns the specified value
 * </p>
 * <p/>
 * Usage: <code>new DumbMatcher(true).match(any)</code> will return always true, no matter <code>any</code> value
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class DumbMatcher implements Matcher
{

    boolean expectedValue;

    public DumbMatcher(boolean expectedValue)
    {
        this.expectedValue = expectedValue;
    }

    /**
     * @see Matcher#match(Object)
     */
    @Override
    public boolean match(Object o)
    {
        return expectedValue;
    }
}
