/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.modules.interceptor.connectors;

import java.lang.reflect.Method;

import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;


/**
 * <p>
 * Every time a method of a @see #org.mule.api.transport.Connector implementation is called this class is called. @see{MethodInterceptor}
 * </p>
 * <p/>
 * <p>
 * This class only acts when the method is connect
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class ConnectorMethodInterceptor implements MethodInterceptor
{

    /**
     * <p>
     * The method of the <code>Connector</code> implementation that is wanted to be mocked
     * </p>
     */
    private static final String METHOD_TO_INTERCEPT = "connect";

    /**
     * @see net.sf.cglib.proxy.MethodInterceptor#intercept(Object, java.lang.reflect.Method, Object[], net.sf.cglib.proxy.MethodProxy)
     */
    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable
    {
        String methodName = method.getName();
        if (methodName.equals(METHOD_TO_INTERCEPT))
        {
            return null;
        }
        return proxy.invokeSuper(obj, args);
    }
}
