/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.interceptor.processors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.processor.MessageProcessor;
import org.mule.modules.interceptor.processors.MessageProcessorId;

public abstract class AbstractMessageProcessorInterceptor
implements MethodInterceptor {
    protected MessageProcessorId id;
    protected Map<String, String> attributes;

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (MessageProcessor.class.isAssignableFrom(obj.getClass()) && method.getName().equals("process") && method.getParameterTypes().length == 1 && MuleEvent.class.isAssignableFrom(method.getParameterTypes()[0])) {
            return this.process(obj, args, proxy);
        }
        return proxy.invokeSuper(obj, args);
    }

    protected abstract Object process(Object var1, Object[] var2, MethodProxy var3) throws Throwable;

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    protected Map<String, Object> getAttributes(MuleEvent event) {
        HashMap<String, Object> processed = new HashMap<String, Object>();
        for (Map.Entry<String, String> attrs : this.attributes.entrySet()) {
            try {
                Object evaluate = this.evaluate(attrs.getValue(), event);
                processed.put(attrs.getKey(), evaluate);
            }
            catch (Throwable t) {
                processed.put(attrs.getKey(), attrs.getValue());
            }
        }
        return processed;
    }

    private Object evaluate(String elementValue, MuleEvent event) {
        Object o;
        Object compareTo = elementValue;
        ExpressionManager expressionManager = event.getMuleContext().getExpressionManager();
        if (expressionManager.isExpression(elementValue)) {
            compareTo = expressionManager.evaluate(elementValue, event);
        } else if (!StringUtils.isEmpty((String)elementValue) && (o = event.getMuleContext().getRegistry().lookupObject(elementValue)) != null) {
            compareTo = o;
        }
        return compareTo;
    }

    public void setId(MessageProcessorId id) {
        this.id = id;
    }
}

