/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.modules.interceptor.processors;

/**
 * <p/>
 * Represents an action that has to be executed based on a {@link MessageProcessorCall}.
 * <p/>
 *
 * @author Mulesoft Inc.
 * @since 3.4.0
 */
public abstract class MessageProcessorCallAction
{
    /**
     * <p>
     * The message processor call representation. When this call is executed then return returnMessage
     * </p>
     */
    protected MessageProcessorCall messageProcessorCall;


    protected MessageProcessorCallAction(MessageProcessorCall messageProcessorCall)
    {
        this.messageProcessorCall = messageProcessorCall;
    }

    public MessageProcessorCall getMessageProcessorCall()
    {
        return messageProcessorCall;
    }
}
