/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.modules.interceptor.processors;

import org.mule.api.MuleMessage;

/**
 * <p>
 * Transformer for a mule message
 * </p>
 *
 * @author Mulesoft Inc.
 * @version since 3.4
 */
public interface MuleMessageTransformer
{

    /**
     * <p>
     * Transform the original message into a new Message
     * </p>
     *
     * @param original <p>
     *                 The message you want to transform
     *                 </p>
     * @return <p>
     *         The transformed message
     *         </p>
     */
    MuleMessage transform(MuleMessage original);
}
