/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.modules.interceptor.matchers;

/**
 * <p>
 * Regular Expression matcher. It compares matches method of {@link String}
 * </p>
 * <p/>
 * Usage: <code>new RegexMatcher(".*regex").match("a regex");</code> will return true.
 *
 * @author Mulesoft Inc.
 * @since 3.4.0
 */
public class RegexMatcher implements Matcher
{

    /**
     * <p>The expected regular expression</p>
     */
    private String expected;

    public RegexMatcher(String expected)
    {
        this.expected = expected;
    }

    /**
     * @see Matcher#match(Object)
     */
    @Override
    public boolean match(Object o)
    {
        if (o == null || !(o instanceof String) )
        {
            return false;
        }
        return ((String) o).matches(expected);
    }
}