/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */


package com.microsoft.schemas.crm._2011.contracts;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PrivilegeDepth.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="PrivilegeDepth">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Basic"/>
 *     &lt;enumeration value="Local"/>
 *     &lt;enumeration value="Deep"/>
 *     &lt;enumeration value="Global"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "PrivilegeDepth")
@XmlEnum
public enum PrivilegeDepth {

    @XmlEnumValue("Basic")
    BASIC("Basic"),
    @XmlEnumValue("Local")
    LOCAL("Local"),
    @XmlEnumValue("Deep")
    DEEP("Deep"),
    @XmlEnumValue("Global")
    GLOBAL("Global");
    private final String value;

    PrivilegeDepth(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PrivilegeDepth fromValue(String v) {
        for (PrivilegeDepth c: PrivilegeDepth.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
