/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/**
 * This file was automatically generated by the Mule Development Kit	
 */
package org.mule.module.dynamicscrm;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.datacontract.schemas._2004._07.system_collections.KeyValuePairOfstringanyType;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.QueryVisitor;
import org.mule.module.dynamicscrm.paging.RetrieveMultipleByQueryPagingDelegate;
import org.mule.module.dynamicscrm.query.DynamicsCrmQueryVisitor;
import org.mule.module.dynamicscrm.query.DynamicsCrmQueryVisitorProxyDebugHandler;
import org.mule.module.dynamicscrm.utils.DynamicsCrmUtils;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.PagingDelegate;

import com.microsoft.schemas._2003._10.serialization.Guid;
import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOfanyType;
import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOfstring;
import com.microsoft.schemas.xrm._2011.contracts.ArrayOfOrderExpression;
import com.microsoft.schemas.xrm._2011.contracts.AttributeCollection;
import com.microsoft.schemas.xrm._2011.contracts.ColumnSet;
import com.microsoft.schemas.xrm._2011.contracts.Entity;
import com.microsoft.schemas.xrm._2011.contracts.EntityCollection;
import com.microsoft.schemas.xrm._2011.contracts.EntityReference;
import com.microsoft.schemas.xrm._2011.contracts.EntityReferenceCollection;
import com.microsoft.schemas.xrm._2011.contracts.EntityRole;
import com.microsoft.schemas.xrm._2011.contracts.FetchExpression;
import com.microsoft.schemas.xrm._2011.contracts.OptionSetValue;
import com.microsoft.schemas.xrm._2011.contracts.OrderExpression;
import com.microsoft.schemas.xrm._2011.contracts.OrderType;
import com.microsoft.schemas.xrm._2011.contracts.OrganizationRequest;
import com.microsoft.schemas.xrm._2011.contracts.OrganizationResponse;
import com.microsoft.schemas.xrm._2011.contracts.PagingInfo;
import com.microsoft.schemas.xrm._2011.contracts.ParameterCollection;
import com.microsoft.schemas.xrm._2011.contracts.QueryByAttribute;
import com.microsoft.schemas.xrm._2011.contracts.Relationship;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationService;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceAssociateOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceCreateOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceDeleteOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceDisassociateOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceRetrieveOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceUpdateOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.metadata.ArrayOfEntityMetadata;
import com.microsoft.schemas.xrm._2011.metadata.AttributeMetadata;
import com.microsoft.schemas.xrm._2011.metadata.AttributeTypeCode;
import com.microsoft.schemas.xrm._2011.metadata.EntityFilters;
import com.microsoft.schemas.xrm._2011.metadata.EntityMetadata;

/**
 * Microsoft Dynamics CRM 2011 Ondemand version
 * <p/>
 * This connector allow the integration with MS Dynamics CRM 2011 Ondemand version.
 * <p/>
 * The service of MS Dynamics CRM provide a few operations that are extensible for all the entities (default and custom)
 * created. A list of the default entities can be found in the MSDN documentation link: <a href="http://msdn.microsoft.com/en-us/library/bb959317.aspx">"http://msdn.microsoft.com/en-us/library/bb959317.aspx</a>
 * <p/>
 * The connector uses Windows Live ID for Authentication.
 * <p/>
 * To use this connector you need a Windows Live ID Account and a Microsoft Dynamics CRM (2011) Online Account
 * <p/>
 *
 * @author MuleSoft, Inc.
 */
public abstract class BaseDynamicsCRMConnector
{

    private final Map<String, EntityMetadata> cachedMetadata = Collections.synchronizedMap(new HashMap<String, EntityMetadata>());

    protected final Log logger = LogFactory.getLog(getClass());

    protected IOrganizationService client;

    /**
     * Create entity
     * <p/> 
     *
     * @param logicalName a logical name
     * @param entity      an entity object represented as a map
     * @return The GUID of the created entity.
     * @throws IOrganizationServiceCreateOrganizationServiceFaultFaultFaultMessage
     *          If create fails
     * @throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
     *          If execute fails
     */    
    public String create(String logicalName, Map<String, Object> entity)
            throws IOrganizationServiceCreateOrganizationServiceFaultFaultFaultMessage, IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
    {
        Entity entityObj = new Entity();
        AttributeCollection collection = populateCollection(logicalName, entity);

        entityObj.setAttributes(collection);
        entityObj.setLogicalName(logicalName);

        return client.create(entityObj).getValue();
    }

    /**
     * Retrieve entity
     * <p/>
     * {@sample.xml ../../../doc/DynamicsCRM-connector.xml.sample dynamicscrm:retrieve}
     *
     * @param logicalName name od the entity to be retrieved
     * @param guid        the guid of the entity to be retrieved
     * @param attributes  attributes that will be retrieved from the entity specified
     * @return attributes of specified entity in Map<String, Object> form
     * @throws IOrganizationServiceRetrieveOrganizationServiceFaultFaultFaultMessage
     *          If retrieve fails
     */
    public Map<String, Object> retrieve(String logicalName, String guid, List<String> attributes)
            throws IOrganizationServiceRetrieveOrganizationServiceFaultFaultFaultMessage
    {
        // declarations
        Entity retrievedEntity;
        ColumnSet columnSet = new ColumnSet();
        ArrayOfstring values = new ArrayOfstring();

        // convert List<String> into ArrayOfString
        for (String attribute : attributes)
        {
            values.getStrings().add(attribute);
        }

        // create a column set, retrieve entity
        columnSet.setColumns(values);
        Guid guidObj = new Guid();
        guidObj.setValue(guid);
        retrievedEntity = client.retrieve(logicalName, guidObj, columnSet);

        return DynamicsCrmUtils.mapEntityToMap(retrievedEntity);
    }

    /**
     * Update entity
     * <p/>
     * {@sample.xml ../../../doc/DynamicsCRM-connector.xml.sample dynamicscrm:update}
     *
     * @param logicalName        logical name of the entity to be updated
     * @param guid               the guid of the entity to be retrieved
     * @param attributesToUpdate the attributes that will be updated, in Map<String, Object> form
     * @throws IOrganizationServiceUpdateOrganizationServiceFaultFaultFaultMessage
     *          If update fails
     * @throws IOrganizationServiceRetrieveOrganizationServiceFaultFaultFaultMessage
     *          If update fails
     * @throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
     *          If execute fails
     */
    public void update(String logicalName, String guid, Map<String, Object> attributesToUpdate)
            throws IOrganizationServiceUpdateOrganizationServiceFaultFaultFaultMessage,
                   IOrganizationServiceRetrieveOrganizationServiceFaultFaultFaultMessage, IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
    {
        // ColumnSet columnSet = new ColumnSet();

        Guid guidObj = new Guid();
        guidObj.setValue(guid);

        // created new AttributeCollection with new values
        AttributeCollection newAttributes = populateCollection(logicalName, attributesToUpdate);

        Entity entity = new Entity();
        entity.setLogicalName(logicalName);
        entity.setId(guidObj);
        entity.setAttributes(newAttributes);

        client.update(entity);
    }

    private AttributeCollection populateCollection(String logicalName, Map<String, Object> entity) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
    {
        AttributeCollection newAttributes = new AttributeCollection();

        EntityMetadata metadata = getCachedMetadata(logicalName);

        for (Map.Entry<String, Object> entry : entity.entrySet())
        {
            KeyValuePairOfstringanyType newKeyValuePair = new KeyValuePairOfstringanyType();
            newKeyValuePair.setKey(entry.getKey());

            Object value = entry.getValue();

            AttributeMetadata attr = getType(entry.getKey(), metadata);
            if (AttributeTypeCode.LOOKUP.equals(attr.getAttributeType())
                || AttributeTypeCode.UNIQUEIDENTIFIER.equals(attr.getAttributeType()))
            {
                Guid guid = new Guid();
                guid.setValue(value.toString());
                newKeyValuePair.setValue(guid);
            }
            else
            {
                newKeyValuePair.setValue(value);
            }

            newAttributes.getKeyValuePairOfstringanyTypes().add(newKeyValuePair);
        }

        return newAttributes;
    }


    private AttributeMetadata getType(String key, EntityMetadata metadata)
    {
        for (AttributeMetadata attr : metadata.getAttributes().getAttributeMetadatas())
        {
            if (key.equals(attr.getLogicalName()))
            {
                return attr;
            }
        }
        return null;
    }

    protected EntityMetadata getCachedMetadata(String logicalName)
            throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
    {
        EntityMetadata metadata = cachedMetadata.get(logicalName);

        if (metadata == null)
        {
            metadata = retrieveCachedMetadata(logicalName);
        }

        return metadata;
    }

    private synchronized EntityMetadata retrieveCachedMetadata(String logicalName)
            throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
    {
        EntityMetadata metadata = cachedMetadata.get(logicalName);
        if (metadata == null)
        {
            metadata = getMetadata(logicalName);
            cachedMetadata.put(logicalName, metadata);
        }

        return metadata;
    }

    protected EntityMetadata getMetadata(String logicalName)
            throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
    {
        // now retrieve the specific entity's attributes
        OrganizationRequest request = new OrganizationRequest();
        request.setRequestName("RetrieveEntity");

        ParameterCollection reqParams = new ParameterCollection();

        EntityFilters filters = new EntityFilters();
        filters.getValues().add("Attributes");

        reqParams.getKeyValuePairOfstringanyTypes().add(createPair("EntityFilters", filters));

        Guid guid = new Guid();
        guid.setValue("00000000-0000-0000-0000-000000000000");
        reqParams.getKeyValuePairOfstringanyTypes().add(createPair("MetadataId", guid));
        reqParams.getKeyValuePairOfstringanyTypes().add(createPair("LogicalName", logicalName));
        reqParams.getKeyValuePairOfstringanyTypes().add(createPair("RetrieveAsIfPublished", true));

        request.setParameters(reqParams);

        OrganizationResponse response = client.execute(request);

        List<KeyValuePairOfstringanyType> keyPairs = response.getResults().getKeyValuePairOfstringanyTypes();

        for (KeyValuePairOfstringanyType pair : keyPairs)
        {

            if (pair.getKey().equals("EntityMetadata"))
            {
                EntityMetadata entity = (EntityMetadata) pair.getValue();

                return entity;
            }
        }

        throw new RuntimeException("Could not find metadata for entity " + logicalName);
    }

    protected KeyValuePairOfstringanyType createPair(String name, Object value)
    {
        KeyValuePairOfstringanyType filterPair = new KeyValuePairOfstringanyType();
        filterPair.setKey(name);
        filterPair.setValue(value);
        return filterPair;
    }

    /**
     * Delete entity
     * <p/>
     * {@sample.xml ../../../doc/DynamicsCRM-connector.xml.sample dynamicscrm:delete}
     *
     * @param logicalName logical name of the entity to be updated
     * @param guid        the guid of the entity to be retrieved
     * @throws IOrganizationServiceDeleteOrganizationServiceFaultFaultFaultMessage
     *          If delete fails
     */
    public void delete(String logicalName, String guid)
            throws IOrganizationServiceDeleteOrganizationServiceFaultFaultFaultMessage
    {
        Guid guidObj = new Guid();
        guidObj.setValue(guid);
        client.delete(logicalName, guidObj);
    }

    /**
     * Execute a business logic method
     * <p/>
     * {@sample.xml ../../../doc/DynamicsCRM-connector.xml.sample dynamicscrm:execute}
     *
     * @param requestName       logical name of request to be made
     * @param requestGuid       the guid of the request to me made
     * @param requestParameters a collection of parameters to the request in Map<String, Object> form
     * @return organization response to execute request
     * @throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
     *          If execute fails
     */
    public Map<String, Object> execute(String requestName, String requestGuid, Map<String, Object> requestParameters)
            throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage
    {
        OrganizationRequest request = new OrganizationRequest();

        ParameterCollection parameters = new ParameterCollection();
        for (Map.Entry<String, Object> entry : requestParameters.entrySet())
        {
            KeyValuePairOfstringanyType pair = new KeyValuePairOfstringanyType();
            pair.setKey(entry.getKey());
            pair.setValue(entry.getValue());
            parameters.getKeyValuePairOfstringanyTypes().add(pair);
        }

        request.setRequestName(requestName);
        if (requestGuid != null)
        {
            Guid guid = new Guid();
            guid.setValue(requestGuid);
            request.setRequestId(guid);
        }
        request.setParameters(parameters);

        OrganizationResponse response = client.execute(request);
        Map<String, Object> responseMap = new HashMap<String, Object>();

        responseMap.put("responseName", response.getResponseName());

        for (KeyValuePairOfstringanyType attribute : response.getResults().getKeyValuePairOfstringanyTypes())
        {
            responseMap.put(attribute.getKey(), attribute.getValue());
        }

        return responseMap;
    }

    /**
     * Retrieve multiple entities by attributes values and sorting options
     * <p/>
     * {@sample.xml ../../../doc/DynamicsCRM-connector.xml.sample dynamicscrm:retrieve-multiple-by-attributes}
     *
     * @param entityName             name of the entity type
     * @param columns                columns to retrieve
     * @param attributes             attributes to filter by
     * @param values                 values of the attributes
     * @param orders                 ordering fields, key is the name, value is "Ascending" or "Descending"
     * @param count                  number of rows to retrieve
     * @param pageNumber             number of page to retrieve
     * @param pagingCookie           paging cookie
     * @param returnTotalRecordCount if total record count should be returned
     * @return entities retrieved
     * @throws IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage
     *          If retrieveMultiple fails
     * @deprecated Use retrieveMultipleByQuery instead
     */
    @Deprecated
    public List<Map<String, Object>> retrieveMultipleByAttributes(String entityName,
                                                                  List<String> columns,
                                                                  List<String> attributes,
                                                                  List<String> values,
                                                                  Map<String, String> orders,
                                                                  Integer count,
                                                                  Integer pageNumber,
                                                                  String pagingCookie,
                                                                  Boolean returnTotalRecordCount)
            throws IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage
    {

        QueryByAttribute query = new QueryByAttribute();

        //entityName
        query.setEntityName(entityName);

        //columnSet
        ColumnSet queryColumns = new ColumnSet();
        queryColumns.setColumns(new ArrayOfstring());
        queryColumns.getColumns().getStrings().addAll(columns);
        query.setColumnSet(queryColumns);

        //attributes
        ArrayOfstring queryAttributes = new ArrayOfstring();
        queryAttributes.getStrings().addAll(attributes);
        query.setAttributes(queryAttributes);

        //values
        ArrayOfanyType queryValues = new ArrayOfanyType();
        queryValues.getAnyTypes().addAll(values);
        query.setValues(queryValues);

        //orders
        if (orders != null)
        {
            query.setOrders(new ArrayOfOrderExpression());
            OrderExpression order = new OrderExpression();
            for (Map.Entry<String, String> entry : orders.entrySet())
            {
                order.setAttributeName(entry.getKey());
                order.setOrderType(OrderType.fromValue(entry.getValue()));
                query.getOrders().getOrderExpressions().add(order);
            }
        }

        //pageInfo
        if (count != null || pageNumber != null || pagingCookie != null || returnTotalRecordCount != null)
        {
            query.setPageInfo(new PagingInfo());
            if (count != null)
            {
                query.getPageInfo().setCount(count);
            }
            if (pageNumber != null)
            {
                query.getPageInfo().setPageNumber(pageNumber);
            }
            if (pagingCookie != null)
            {
                query.getPageInfo().setPagingCookie(pagingCookie);
            }
            if (returnTotalRecordCount != null)
            {
                query.getPageInfo().setReturnTotalRecordCount(returnTotalRecordCount);
            }
        }

        EntityCollection entities = client.retrieveMultiple(query);

        return DynamicsCrmUtils.mapEntityCollectionToMapCollection(entities);
    }

    /**
     * Retrieve multiple entities by a query described by and XML
     * <p/>
     * The definition of the Microsoft XML Query Language can be found in the Schema Definition in this link: <a href="http://msdn.microsoft.com/en-us/library/bb930489.aspx">http://msdn.microsoft.com/en-us/library/bb930489.aspx</a>
     * <p/>
     * The aggregation examples can be found in this link: <a href="http://msdn.microsoft.com/en-us/library/gg309565.aspx">http://msdn.microsoft.com/en-us/library/gg309565.aspx</a>
     * <p/>
     * {@sample.xml ../../../doc/DynamicsCRM-connector.xml.sample dynamicscrm:retrieve-multiple-by-query}
     *
     * @param queryXml query XML
     * @return A paging delegate with all the entities. This handles pagination internally on-demand.
     * @throws IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage
     *          If retrieveMultiple fails
     */
    public PagingDelegate<Map<String, Object>> retrieveMultipleByQuery(DsqlQuery queryXml, PagingConfiguration pagingConfiguration)
            throws IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage
    {
        FetchExpression query = new FetchExpression();
        query.setQuery(buildFetchXmlWithPages(queryXml, pagingConfiguration.getFetchSize()));
        
        EntityCollection entities = client.retrieveMultiple(query);
        return new RetrieveMultipleByQueryPagingDelegate(client, entities, queryXml, pagingConfiguration.getFetchSize());
    }
    
    protected String buildFetchXmlWithPages(DsqlQuery query, Integer fetchSize) {
    	DynamicsCrmQueryVisitor queryVisitor = new DynamicsCrmQueryVisitor(fetchSize);
    	// If DEBUG is enabled, activate the proxy to log the calls to the DefaultQueryVisitor operations
    	if (logger.isDebugEnabled()) {
    		DynamicsCrmQueryVisitorProxyDebugHandler proxy = new DynamicsCrmQueryVisitorProxyDebugHandler((DynamicsCrmQueryVisitor)queryVisitor);
    		Class<?>[] interfaces = new Class[] {QueryVisitor.class};
    		QueryVisitor newProxyInstance = (QueryVisitor) Proxy.newProxyInstance(BaseDynamicsCRMConnector.class.getClassLoader(), interfaces, proxy);
    		query.accept(newProxyInstance);
    		String nativeQuery = queryVisitor.getQuery();
    		logger.debug("Native Query:" + nativeQuery);
    		return nativeQuery;
    	} else {
    		query.accept(queryVisitor);
    		return queryVisitor.getQuery();
    	}
    }

    /**
     * Associate a set of entities
     * <p/>
     * {@sample.xml ../../../doc/DynamicsCRM-connector.xml.sample dynamicscrm:associate}
     *
     * @param entityName                logical name of entity
     * @param entityId                  guid of entity in string form
     * @param relationshipEntityRoleIsReferenced
     *                                  if the role of the entity is "Referenced" (true) of "Referencing" (false)
     * @param relationshipSchemaName    the type of relationship
     * @param relatedEntitiesAttributes list of the attributes of related entities
     * @throws IOrganizationServiceAssociateOrganizationServiceFaultFaultFaultMessage
     *          If associate fails
     */
    public void associate(String entityName, String entityId, Boolean relationshipEntityRoleIsReferenced, String relationshipSchemaName, List<Map<String, Object>> relatedEntitiesAttributes)
            throws IOrganizationServiceAssociateOrganizationServiceFaultFaultFaultMessage
    {
        Guid entityGuid = new Guid();
        entityGuid.setValue(entityId);

        Relationship relationship = new Relationship();
        if (relationshipEntityRoleIsReferenced)
        {
            relationship.setPrimaryEntityRole(EntityRole.REFERENCED);
        }
        else
        {
            relationship.setPrimaryEntityRole(EntityRole.REFERENCING);
        }
        relationship.setSchemaName(relationshipSchemaName);

        client.associate(entityName, entityGuid, relationship, mapAttributesListToEntityReferenceCollection(relatedEntitiesAttributes));
    }

    /**
     * Disassociate a set of entities
     * <p/>
     * {@sample.xml ../../../doc/DynamicsCRM-connector.xml.sample dynamicscrm:disassociate}
     *
     * @param entityName                logical name of entity
     * @param entityId                  guid of entity in string form
     * @param relationshipEntityRoleIsReferenced
     *                                  if the role of the entity is "Referenced" (true) of "Referencing" (false)
     * @param relationshipSchemaName    the type of relationship
     * @param relatedEntitiesAttributes list of the attributes of related entities
     * @throws IOrganizationServiceDisassociateOrganizationServiceFaultFaultFaultMessage
     *          If disassociate fails
     */
    public void disassociate(String entityName, String entityId, Boolean relationshipEntityRoleIsReferenced, String relationshipSchemaName, List<Map<String, Object>> relatedEntitiesAttributes)
            throws IOrganizationServiceDisassociateOrganizationServiceFaultFaultFaultMessage
    {
        Guid entityGuid = new Guid();
        entityGuid.setValue(entityId);

        Relationship relationship = new Relationship();
        if (relationshipEntityRoleIsReferenced)
        {
            relationship.setPrimaryEntityRole(EntityRole.REFERENCED);
        }
        else
        {
            relationship.setPrimaryEntityRole(EntityRole.REFERENCING);
        }
        relationship.setSchemaName(relationshipSchemaName);

        client.disassociate(entityName, entityGuid, relationship, mapAttributesListToEntityReferenceCollection(relatedEntitiesAttributes));
    }

    private EntityReferenceCollection mapAttributesListToEntityReferenceCollection(List<Map<String, Object>> entitiesAttributes)
    {
        EntityReferenceCollection relatedEntities = new EntityReferenceCollection();

        for (Map<String, Object> relatedEntityAttributes : entitiesAttributes)
        {
            EntityReference relatedEntity = new EntityReference();
            for (Map.Entry<String, Object> entry : relatedEntityAttributes.entrySet())
            {
                if (entry.getKey().equals("id"))
                {
                    Guid guid = new Guid();
                    guid.setValue(entry.getValue().toString());
                    relatedEntity.setId(guid);
                }
                else if (entry.getKey().equals("logicalName"))
                {
                    relatedEntity.setLogicalName(entry.getValue().toString());
                }
                else if (entry.getKey().equals("name"))
                {
                    relatedEntity.setName(entry.getValue().toString());
                }
            }
            relatedEntities.getEntityReferences().add(relatedEntity);
        }

        return relatedEntities;
    }
    
   public List<MetaDataKey> getMetadataKeys() throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        OrganizationResponse response = getEntities();
        
        List<MetaDataKey> keys = new ArrayList<MetaDataKey>();
        List<KeyValuePairOfstringanyType> keyPairs = response.getResults().getKeyValuePairOfstringanyTypes();
        for (KeyValuePairOfstringanyType pair : keyPairs) {
            
            if (pair.getKey().equals("EntityMetadata")) {
                ArrayOfEntityMetadata metadataArray = (ArrayOfEntityMetadata) pair.getValue();
                
                for (EntityMetadata md : metadataArray.getEntityMetadatas()) {
                    String name = md.getLogicalName();
                    if (name != null) {
                        keys.add(new DefaultMetaDataKey(name, name));
                    }
                }
            }
        }
        return keys;
    }

    private OrganizationResponse getEntities()
            throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        OrganizationRequest request = new OrganizationRequest();
        request.setRequestName("RetrieveAllEntities");
        
        ParameterCollection reqParams = new ParameterCollection();
        
        EntityFilters filters = new EntityFilters();
        filters.getValues().add("Entity");

        reqParams.getKeyValuePairOfstringanyTypes().add(createPair("EntityFilters", filters));
        reqParams.getKeyValuePairOfstringanyTypes().add(createPair("RetrieveAsIfPublished", true));
        
        request.setParameters(reqParams);
        
        OrganizationResponse response = client.execute(request);
        return response;
    }
    
    public MetaData getMetadata(MetaDataKey key) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage  {
        EntityMetadata entity = getMetadata(key.getId());

        Map<String, MetaDataModel> map = new HashMap<String, MetaDataModel>();
        
        for (AttributeMetadata attrMD : entity.getAttributes().getAttributeMetadatas()) {
            MetaDataModel model = createAttributeMetadata(attrMD);
            // We add the validation of isIsValidForRead(). Attributes that has a false in this field cannot be requested
            // in for example a Query.
            if (model != null && attrMD.isIsValidForRead()) {
                map.put(attrMD.getLogicalName(), model);
            } 
        }

        MetaDataModel model = new DefaultDefinedMapMetaDataModel(map);
        
        return new DefaultMetaData(model);
    }
    
    private MetaDataModel createAttributeMetadata(AttributeMetadata attrMD) {     
        
        switch (attrMD.getAttributeType()) {
        case BIG_INT:
            return new DefaultSimpleMetaDataModel(DataType.NUMBER);
        case BOOLEAN:
            return new DefaultSimpleMetaDataModel(DataType.BOOLEAN);
        case CALENDAR_RULES:
            return null;
        case CUSTOMER:
            return null;
        case DATE_TIME:
            return new DefaultSimpleMetaDataModel(DataType.DATE_TIME);
        case DECIMAL:
            return new DefaultSimpleMetaDataModel(DataType.NUMBER);
        case DOUBLE:
            return new DefaultSimpleMetaDataModel(DataType.NUMBER);
        case ENTITY_NAME:
            return new DefaultSimpleMetaDataModel(DataType.STRING);
        case INTEGER:
            return new DefaultSimpleMetaDataModel(DataType.NUMBER);
        case LOOKUP:
            return new DefaultSimpleMetaDataModel(DataType.STRING);
        case MANAGED_PROPERTY:
            return null;
        case MEMO:
            return null;
        case MONEY:
            return new DefaultSimpleMetaDataModel(DataType.NUMBER);
        case OWNER:
            return new DefaultSimpleMetaDataModel(DataType.STRING);
        case PARTY_LIST:
            System.out.println("Party List " + attrMD.getLogicalName());
            return null;
        case PICKLIST:
            return new DefaultPojoMetaDataModel(OptionSetValue.class);
        case STATE:
            return new DefaultSimpleMetaDataModel(DataType.STRING);
        case STATUS:
            return new DefaultSimpleMetaDataModel(DataType.STRING);
        case STRING:
            return new DefaultSimpleMetaDataModel(DataType.STRING);
        case UNIQUEIDENTIFIER:
            return new DefaultSimpleMetaDataModel(DataType.STRING);
        case VIRTUAL:
            // skip virtual fields - how do you tell the type?
            return null;
        default:
            return null;
        }
    }
}