/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.dynamicscrm.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicsCrmQueryVisitorProxyDebugHandler implements InvocationHandler {

	final static private Log logger = LogFactory.getLog(DynamicsCrmQueryVisitorProxyDebugHandler.class);
	private DynamicsCrmQueryVisitor proxiedClass;	
	
	public DynamicsCrmQueryVisitorProxyDebugHandler(DynamicsCrmQueryVisitor proxiedClass) {
		super();
		this.proxiedClass = proxiedClass;
	}

	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		try {
			logger.debug(String.format("Calling %s with params %s", method.getName(), args));
            return method.invoke(proxiedClass, args);
        } catch ( Exception e ) {
            throw new RuntimeException(String.format("Exception while calling %s with params %s", method.getName(), args), e);
        }
	}

}
