/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.dynamicscrm;

import com.microsoft.schemas._2003._10.serialization.Guid;
import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOfanyType;
import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOfstring;
import com.microsoft.schemas.xrm._2011.contracts.ArrayOfOrderExpression;
import com.microsoft.schemas.xrm._2011.contracts.AttributeCollection;
import com.microsoft.schemas.xrm._2011.contracts.ColumnSet;
import com.microsoft.schemas.xrm._2011.contracts.Entity;
import com.microsoft.schemas.xrm._2011.contracts.EntityCollection;
import com.microsoft.schemas.xrm._2011.contracts.EntityReference;
import com.microsoft.schemas.xrm._2011.contracts.EntityReferenceCollection;
import com.microsoft.schemas.xrm._2011.contracts.EntityRole;
import com.microsoft.schemas.xrm._2011.contracts.FetchExpression;
import com.microsoft.schemas.xrm._2011.contracts.OptionSetValue;
import com.microsoft.schemas.xrm._2011.contracts.OrderExpression;
import com.microsoft.schemas.xrm._2011.contracts.OrderType;
import com.microsoft.schemas.xrm._2011.contracts.OrganizationRequest;
import com.microsoft.schemas.xrm._2011.contracts.OrganizationResponse;
import com.microsoft.schemas.xrm._2011.contracts.PagingInfo;
import com.microsoft.schemas.xrm._2011.contracts.ParameterCollection;
import com.microsoft.schemas.xrm._2011.contracts.QueryByAttribute;
import com.microsoft.schemas.xrm._2011.contracts.Relationship;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationService;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceAssociateOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceCreateOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceDeleteOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceDisassociateOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceRetrieveOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceUpdateOrganizationServiceFaultFaultFaultMessage;
import com.microsoft.schemas.xrm._2011.metadata.ArrayOfEntityMetadata;
import com.microsoft.schemas.xrm._2011.metadata.AttributeMetadata;
import com.microsoft.schemas.xrm._2011.metadata.AttributeTypeCode;
import com.microsoft.schemas.xrm._2011.metadata.EntityFilters;
import com.microsoft.schemas.xrm._2011.metadata.EntityMetadata;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.datacontract.schemas._2004._07.system_collections.KeyValuePairOfstringanyType;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.QueryVisitor;
import org.mule.module.dynamicscrm.paging.RetrieveMultipleByQueryPagingDelegate;
import org.mule.module.dynamicscrm.query.DynamicsCrmQueryVisitor;
import org.mule.module.dynamicscrm.query.DynamicsCrmQueryVisitorProxyDebugHandler;
import org.mule.module.dynamicscrm.utils.DynamicsCrmUtils;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.PagingDelegate;

public abstract class BaseDynamicsCRMConnector {
    private final Map<String, EntityMetadata> cachedMetadata = Collections.synchronizedMap(new HashMap());
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected IOrganizationService client;

    public String create(String logicalName, Map<String, Object> entity) throws IOrganizationServiceCreateOrganizationServiceFaultFaultFaultMessage, IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        Entity entityObj = new Entity();
        AttributeCollection collection = this.populateCollection(logicalName, entity);
        entityObj.setAttributes(collection);
        entityObj.setLogicalName(logicalName);
        return this.client.create(entityObj).getValue();
    }

    public Map<String, Object> retrieve(String logicalName, String guid, List<String> attributes) throws IOrganizationServiceRetrieveOrganizationServiceFaultFaultFaultMessage {
        ColumnSet columnSet = new ColumnSet();
        ArrayOfstring values = new ArrayOfstring();
        for (String attribute : attributes) {
            values.getStrings().add(attribute);
        }
        columnSet.setColumns(values);
        Guid guidObj = new Guid();
        guidObj.setValue(guid);
        Entity retrievedEntity = this.client.retrieve(logicalName, guidObj, columnSet);
        return DynamicsCrmUtils.mapEntityToMap(retrievedEntity);
    }

    public void update(String logicalName, String guid, Map<String, Object> attributesToUpdate) throws IOrganizationServiceUpdateOrganizationServiceFaultFaultFaultMessage, IOrganizationServiceRetrieveOrganizationServiceFaultFaultFaultMessage, IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        Guid guidObj = new Guid();
        guidObj.setValue(guid);
        AttributeCollection newAttributes = this.populateCollection(logicalName, attributesToUpdate);
        Entity entity = new Entity();
        entity.setLogicalName(logicalName);
        entity.setId(guidObj);
        entity.setAttributes(newAttributes);
        this.client.update(entity);
    }

    private AttributeCollection populateCollection(String logicalName, Map<String, Object> entity) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        AttributeCollection newAttributes = new AttributeCollection();
        EntityMetadata metadata = this.getCachedMetadata(logicalName);
        for (Map.Entry<String, Object> entry : entity.entrySet()) {
            KeyValuePairOfstringanyType newKeyValuePair = new KeyValuePairOfstringanyType();
            newKeyValuePair.setKey(entry.getKey());
            Object value = entry.getValue();
            AttributeMetadata attr = this.getType(entry.getKey(), metadata);
            if (AttributeTypeCode.LOOKUP.equals((Object)attr.getAttributeType()) || AttributeTypeCode.UNIQUEIDENTIFIER.equals((Object)attr.getAttributeType())) {
                Guid guid = new Guid();
                guid.setValue(value.toString());
                newKeyValuePair.setValue(guid);
            } else {
                newKeyValuePair.setValue(value);
            }
            newAttributes.getKeyValuePairOfstringanyTypes().add(newKeyValuePair);
        }
        return newAttributes;
    }

    private AttributeMetadata getType(String key, EntityMetadata metadata) {
        for (AttributeMetadata attr : metadata.getAttributes().getAttributeMetadatas()) {
            if (!key.equals(attr.getLogicalName())) continue;
            return attr;
        }
        return null;
    }

    protected EntityMetadata getCachedMetadata(String logicalName) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        EntityMetadata metadata = this.cachedMetadata.get(logicalName);
        if (metadata == null) {
            metadata = this.retrieveCachedMetadata(logicalName);
        }
        return metadata;
    }

    private synchronized EntityMetadata retrieveCachedMetadata(String logicalName) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        EntityMetadata metadata = this.cachedMetadata.get(logicalName);
        if (metadata == null) {
            metadata = this.getMetadata(logicalName);
            this.cachedMetadata.put(logicalName, metadata);
        }
        return metadata;
    }

    protected EntityMetadata getMetadata(String logicalName) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        OrganizationRequest request = new OrganizationRequest();
        request.setRequestName("RetrieveEntity");
        ParameterCollection reqParams = new ParameterCollection();
        EntityFilters filters = new EntityFilters();
        filters.getValues().add("Attributes");
        reqParams.getKeyValuePairOfstringanyTypes().add(this.createPair("EntityFilters", filters));
        Guid guid = new Guid();
        guid.setValue("00000000-0000-0000-0000-000000000000");
        reqParams.getKeyValuePairOfstringanyTypes().add(this.createPair("MetadataId", guid));
        reqParams.getKeyValuePairOfstringanyTypes().add(this.createPair("LogicalName", logicalName));
        reqParams.getKeyValuePairOfstringanyTypes().add(this.createPair("RetrieveAsIfPublished", true));
        request.setParameters(reqParams);
        OrganizationResponse response = this.client.execute(request);
        List<KeyValuePairOfstringanyType> keyPairs = response.getResults().getKeyValuePairOfstringanyTypes();
        for (KeyValuePairOfstringanyType pair : keyPairs) {
            if (!pair.getKey().equals("EntityMetadata")) continue;
            EntityMetadata entity = (EntityMetadata)pair.getValue();
            return entity;
        }
        throw new RuntimeException("Could not find metadata for entity " + logicalName);
    }

    protected KeyValuePairOfstringanyType createPair(String name, Object value) {
        KeyValuePairOfstringanyType filterPair = new KeyValuePairOfstringanyType();
        filterPair.setKey(name);
        filterPair.setValue(value);
        return filterPair;
    }

    public void delete(String logicalName, String guid) throws IOrganizationServiceDeleteOrganizationServiceFaultFaultFaultMessage {
        Guid guidObj = new Guid();
        guidObj.setValue(guid);
        this.client.delete(logicalName, guidObj);
    }

    public Map<String, Object> execute(String requestName, String requestGuid, Map<String, Object> requestParameters) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        OrganizationRequest request = new OrganizationRequest();
        ParameterCollection parameters = new ParameterCollection();
        for (Map.Entry<String, Object> entry : requestParameters.entrySet()) {
            KeyValuePairOfstringanyType pair = new KeyValuePairOfstringanyType();
            pair.setKey(entry.getKey());
            pair.setValue(entry.getValue());
            parameters.getKeyValuePairOfstringanyTypes().add(pair);
        }
        request.setRequestName(requestName);
        if (requestGuid != null) {
            Guid guid = new Guid();
            guid.setValue(requestGuid);
            request.setRequestId(guid);
        }
        request.setParameters(parameters);
        OrganizationResponse response = this.client.execute(request);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("responseName", response.getResponseName());
        for (KeyValuePairOfstringanyType attribute : response.getResults().getKeyValuePairOfstringanyTypes()) {
            responseMap.put(attribute.getKey(), attribute.getValue());
        }
        return responseMap;
    }

    @Deprecated
    public List<Map<String, Object>> retrieveMultipleByAttributes(String entityName, List<String> columns, List<String> attributes, List<String> values, Map<String, String> orders, Integer count, Integer pageNumber, String pagingCookie, Boolean returnTotalRecordCount) throws IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage {
        QueryByAttribute query = new QueryByAttribute();
        query.setEntityName(entityName);
        ColumnSet queryColumns = new ColumnSet();
        queryColumns.setColumns(new ArrayOfstring());
        queryColumns.getColumns().getStrings().addAll(columns);
        query.setColumnSet(queryColumns);
        ArrayOfstring queryAttributes = new ArrayOfstring();
        queryAttributes.getStrings().addAll(attributes);
        query.setAttributes(queryAttributes);
        ArrayOfanyType queryValues = new ArrayOfanyType();
        queryValues.getAnyTypes().addAll(values);
        query.setValues(queryValues);
        if (orders != null) {
            query.setOrders(new ArrayOfOrderExpression());
            OrderExpression order = new OrderExpression();
            for (Map.Entry<String, String> entry : orders.entrySet()) {
                order.setAttributeName(entry.getKey());
                order.setOrderType(OrderType.fromValue(entry.getValue()));
                query.getOrders().getOrderExpressions().add(order);
            }
        }
        if (count != null || pageNumber != null || pagingCookie != null || returnTotalRecordCount != null) {
            query.setPageInfo(new PagingInfo());
            if (count != null) {
                query.getPageInfo().setCount(count);
            }
            if (pageNumber != null) {
                query.getPageInfo().setPageNumber(pageNumber);
            }
            if (pagingCookie != null) {
                query.getPageInfo().setPagingCookie(pagingCookie);
            }
            if (returnTotalRecordCount != null) {
                query.getPageInfo().setReturnTotalRecordCount(returnTotalRecordCount);
            }
        }
        EntityCollection entities = this.client.retrieveMultiple(query);
        return DynamicsCrmUtils.mapEntityCollectionToMapCollection(entities);
    }

    public PagingDelegate<Map<String, Object>> retrieveMultipleByQuery(DsqlQuery queryXml, PagingConfiguration pagingConfiguration) throws IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage {
        FetchExpression query = new FetchExpression();
        query.setQuery(this.buildFetchXmlWithPages(queryXml, pagingConfiguration.getFetchSize()));
        EntityCollection entities = this.client.retrieveMultiple(query);
        return new RetrieveMultipleByQueryPagingDelegate(this.client, entities, queryXml, pagingConfiguration.getFetchSize());
    }

    protected String buildFetchXmlWithPages(DsqlQuery query, Integer fetchSize) {
        DynamicsCrmQueryVisitor queryVisitor = new DynamicsCrmQueryVisitor(fetchSize);
        if (this.logger.isDebugEnabled()) {
            DynamicsCrmQueryVisitorProxyDebugHandler proxy = new DynamicsCrmQueryVisitorProxyDebugHandler(queryVisitor);
            Class[] interfaces = new Class[]{QueryVisitor.class};
            QueryVisitor newProxyInstance = (QueryVisitor)Proxy.newProxyInstance(BaseDynamicsCRMConnector.class.getClassLoader(), interfaces, (InvocationHandler)proxy);
            query.accept(newProxyInstance);
            String nativeQuery = queryVisitor.getQuery();
            this.logger.debug((Object)("Native Query:" + nativeQuery));
            return nativeQuery;
        }
        query.accept((QueryVisitor)queryVisitor);
        return queryVisitor.getQuery();
    }

    public void associate(String entityName, String entityId, Boolean relationshipEntityRoleIsReferenced, String relationshipSchemaName, List<Map<String, Object>> relatedEntitiesAttributes) throws IOrganizationServiceAssociateOrganizationServiceFaultFaultFaultMessage {
        Guid entityGuid = new Guid();
        entityGuid.setValue(entityId);
        Relationship relationship = new Relationship();
        if (relationshipEntityRoleIsReferenced.booleanValue()) {
            relationship.setPrimaryEntityRole(EntityRole.REFERENCED);
        } else {
            relationship.setPrimaryEntityRole(EntityRole.REFERENCING);
        }
        relationship.setSchemaName(relationshipSchemaName);
        this.client.associate(entityName, entityGuid, relationship, this.mapAttributesListToEntityReferenceCollection(relatedEntitiesAttributes));
    }

    public void disassociate(String entityName, String entityId, Boolean relationshipEntityRoleIsReferenced, String relationshipSchemaName, List<Map<String, Object>> relatedEntitiesAttributes) throws IOrganizationServiceDisassociateOrganizationServiceFaultFaultFaultMessage {
        Guid entityGuid = new Guid();
        entityGuid.setValue(entityId);
        Relationship relationship = new Relationship();
        if (relationshipEntityRoleIsReferenced.booleanValue()) {
            relationship.setPrimaryEntityRole(EntityRole.REFERENCED);
        } else {
            relationship.setPrimaryEntityRole(EntityRole.REFERENCING);
        }
        relationship.setSchemaName(relationshipSchemaName);
        this.client.disassociate(entityName, entityGuid, relationship, this.mapAttributesListToEntityReferenceCollection(relatedEntitiesAttributes));
    }

    private EntityReferenceCollection mapAttributesListToEntityReferenceCollection(List<Map<String, Object>> entitiesAttributes) {
        EntityReferenceCollection relatedEntities = new EntityReferenceCollection();
        for (Map<String, Object> relatedEntityAttributes : entitiesAttributes) {
            EntityReference relatedEntity = new EntityReference();
            for (Map.Entry<String, Object> entry : relatedEntityAttributes.entrySet()) {
                if (entry.getKey().equals("id")) {
                    Guid guid = new Guid();
                    guid.setValue(entry.getValue().toString());
                    relatedEntity.setId(guid);
                    continue;
                }
                if (entry.getKey().equals("logicalName")) {
                    relatedEntity.setLogicalName(entry.getValue().toString());
                    continue;
                }
                if (!entry.getKey().equals("name")) continue;
                relatedEntity.setName(entry.getValue().toString());
            }
            relatedEntities.getEntityReferences().add(relatedEntity);
        }
        return relatedEntities;
    }

    public List<MetaDataKey> getMetadataKeys() throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        OrganizationResponse response = this.getEntities();
        ArrayList<MetaDataKey> keys = new ArrayList<MetaDataKey>();
        List<KeyValuePairOfstringanyType> keyPairs = response.getResults().getKeyValuePairOfstringanyTypes();
        for (KeyValuePairOfstringanyType pair : keyPairs) {
            if (!pair.getKey().equals("EntityMetadata")) continue;
            ArrayOfEntityMetadata metadataArray = (ArrayOfEntityMetadata)pair.getValue();
            for (EntityMetadata md : metadataArray.getEntityMetadatas()) {
                String name = md.getLogicalName();
                if (name == null) continue;
                keys.add((MetaDataKey)new DefaultMetaDataKey(name, name));
            }
        }
        return keys;
    }

    private OrganizationResponse getEntities() throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        OrganizationRequest request = new OrganizationRequest();
        request.setRequestName("RetrieveAllEntities");
        ParameterCollection reqParams = new ParameterCollection();
        EntityFilters filters = new EntityFilters();
        filters.getValues().add("Entity");
        reqParams.getKeyValuePairOfstringanyTypes().add(this.createPair("EntityFilters", filters));
        reqParams.getKeyValuePairOfstringanyTypes().add(this.createPair("RetrieveAsIfPublished", true));
        request.setParameters(reqParams);
        OrganizationResponse response = this.client.execute(request);
        return response;
    }

    public MetaData getMetadata(MetaDataKey key) throws IOrganizationServiceExecuteOrganizationServiceFaultFaultFaultMessage {
        EntityMetadata entity = this.getMetadata(key.getId());
        HashMap<String, MetaDataModel> map = new HashMap<String, MetaDataModel>();
        for (AttributeMetadata attrMD : entity.getAttributes().getAttributeMetadatas()) {
            MetaDataModel model = this.createAttributeMetadata(attrMD);
            if (model == null || !attrMD.isIsValidForRead().booleanValue()) continue;
            map.put(attrMD.getLogicalName(), model);
        }
        DefaultDefinedMapMetaDataModel model = new DefaultDefinedMapMetaDataModel(map);
        return new DefaultMetaData((MetaDataModel)model);
    }

    private MetaDataModel createAttributeMetadata(AttributeMetadata attrMD) {
        switch (attrMD.getAttributeType()) {
            case BIG_INT: {
                return new DefaultSimpleMetaDataModel(DataType.NUMBER);
            }
            case BOOLEAN: {
                return new DefaultSimpleMetaDataModel(DataType.BOOLEAN);
            }
            case CALENDAR_RULES: {
                return null;
            }
            case CUSTOMER: {
                return null;
            }
            case DATE_TIME: {
                return new DefaultSimpleMetaDataModel(DataType.DATE_TIME);
            }
            case DECIMAL: {
                return new DefaultSimpleMetaDataModel(DataType.NUMBER);
            }
            case DOUBLE: {
                return new DefaultSimpleMetaDataModel(DataType.NUMBER);
            }
            case ENTITY_NAME: {
                return new DefaultSimpleMetaDataModel(DataType.STRING);
            }
            case INTEGER: {
                return new DefaultSimpleMetaDataModel(DataType.NUMBER);
            }
            case LOOKUP: {
                return new DefaultSimpleMetaDataModel(DataType.STRING);
            }
            case MANAGED_PROPERTY: {
                return null;
            }
            case MEMO: {
                return null;
            }
            case MONEY: {
                return new DefaultSimpleMetaDataModel(DataType.NUMBER);
            }
            case OWNER: {
                return new DefaultSimpleMetaDataModel(DataType.STRING);
            }
            case PARTY_LIST: {
                System.out.println("Party List " + attrMD.getLogicalName());
                return null;
            }
            case PICKLIST: {
                return new DefaultPojoMetaDataModel(OptionSetValue.class);
            }
            case STATE: {
                return new DefaultSimpleMetaDataModel(DataType.STRING);
            }
            case STATUS: {
                return new DefaultSimpleMetaDataModel(DataType.STRING);
            }
            case STRING: {
                return new DefaultSimpleMetaDataModel(DataType.STRING);
            }
            case UNIQUEIDENTIFIER: {
                return new DefaultSimpleMetaDataModel(DataType.STRING);
            }
            case VIRTUAL: {
                return null;
            }
        }
        return null;
    }
}

