/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.dynamicscrm.paging;

import com.microsoft.schemas.xrm._2011.contracts.EntityCollection;
import com.microsoft.schemas.xrm._2011.contracts.FetchExpression;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationService;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.QueryVisitor;
import org.mule.module.dynamicscrm.paging.exception.DynamicsCrmPagingException;
import org.mule.module.dynamicscrm.query.DynamicsCrmQueryVisitor;
import org.mule.module.dynamicscrm.utils.DynamicsCrmUtils;
import org.mule.streaming.PagingDelegate;

public class RetrieveMultipleByQueryPagingDelegate
extends PagingDelegate<Map<String, Object>> {
    private static final Log logger = LogFactory.getLog(RetrieveMultipleByQueryPagingDelegate.class);
    private IOrganizationService client;
    private EntityCollection lastEntityCollection;
    private DsqlQuery lastQuery;
    private boolean firstPage;
    private Integer pageSize;
    private Integer limit;
    private Integer currentLimit;

    public RetrieveMultipleByQueryPagingDelegate(IOrganizationService client, EntityCollection entityCollection, DsqlQuery query, Integer pageSize) {
        this.client = client;
        this.lastEntityCollection = entityCollection;
        this.lastQuery = query;
        this.pageSize = pageSize;
        this.firstPage = true;
        this.limit = query.getLimit() > 0 ? Integer.valueOf(query.getLimit()) : null;
        this.currentLimit = 0;
    }

    public void close() throws MuleException {
        if (this.lastEntityCollection != null) {
            this.lastEntityCollection = null;
        }
        if (this.lastQuery != null) {
            this.lastQuery = null;
        }
        this.client = null;
    }

    public List<Map<String, Object>> getPage() {
        logger.debug((Object)"Requesting new page");
        if (this.firstPage) {
            this.firstPage = false;
            if (this.lastEntityCollection != null) {
                List<Map<String, Object>> mapEntityCollectionToMapCollection = DynamicsCrmUtils.mapEntityCollectionToMapCollection(this.lastEntityCollection);
                mapEntityCollectionToMapCollection = this.trimMapForLimit(mapEntityCollectionToMapCollection);
                this.addAmmountToCurrentLimit(mapEntityCollectionToMapCollection);
                return mapEntityCollectionToMapCollection;
            }
            return null;
        }
        if (this.limit != null && this.limit > 0 && this.currentLimit >= this.limit) {
            return null;
        }
        if (this.lastEntityCollection != null && this.lastEntityCollection.isMoreRecords().booleanValue() && this.lastQuery != null) {
            this.lastQuery.setOffset(this.lastQuery.getOffset() > 0 ? this.lastQuery.getOffset() + 1 : 2);
            logger.debug((Object)("Calling service for page " + this.lastQuery.getOffset()));
            DynamicsCrmQueryVisitor queryVisitor = new DynamicsCrmQueryVisitor(this.pageSize);
            this.lastQuery.accept((QueryVisitor)queryVisitor);
            String nativeQuery = queryVisitor.getQuery();
            FetchExpression query = new FetchExpression();
            query.setQuery(nativeQuery);
            try {
                this.lastEntityCollection = this.client.retrieveMultiple(query);
            }
            catch (IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage e) {
                throw new DynamicsCrmPagingException(e);
            }
            List<Map<String, Object>> mapEntityCollectionToMapCollection = DynamicsCrmUtils.mapEntityCollectionToMapCollection(this.lastEntityCollection);
            mapEntityCollectionToMapCollection = this.trimMapForLimit(mapEntityCollectionToMapCollection);
            this.addAmmountToCurrentLimit(mapEntityCollectionToMapCollection);
            return mapEntityCollectionToMapCollection;
        }
        return null;
    }

    private List<Map<String, Object>> trimMapForLimit(List<Map<String, Object>> map) {
        if (this.limit != null && this.limit > 0 && map != null) {
            int size = map.size();
            if (this.currentLimit + size > this.limit) {
                int trimToSize = this.limit - this.currentLimit;
                map = map.subList(0, trimToSize);
            }
        }
        return map;
    }

    private void addAmmountToCurrentLimit(List<?> list) {
        if (list != null) {
            this.currentLimit = this.currentLimit + list.size();
        }
    }

    public int getTotalResults() {
        return -1;
    }
}

