/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.dynamicscrm.query.where;

import java.util.LinkedList;
import java.util.List;
import org.mule.module.dynamicscrm.query.where.DynamicsCrmWhereComponent;

public class DynamicsCrmWhereComposite
implements DynamicsCrmWhereComponent {
    private List<DynamicsCrmWhereComponent> components;
    private DynamicsCrmWhereComposite parentComponent;
    private Comparation comparation;

    public DynamicsCrmWhereComposite(DynamicsCrmWhereComposite parentComponent) {
        this.parentComponent = parentComponent;
        this.components = new LinkedList<DynamicsCrmWhereComponent>();
        this.comparation = null;
    }

    public void addComponent(DynamicsCrmWhereComponent component) {
        this.components.add(component);
    }

    public DynamicsCrmWhereComposite getParentComposite() {
        return this.parentComponent;
    }

    public Comparation getComparation() {
        return this.comparation;
    }

    public void setComparation(Comparation comparation) {
        this.comparation = comparation;
    }

    @Override
    public String getQueryXml() {
        StringBuffer strBuff = new StringBuffer();
        if (this.comparation != null) {
            strBuff.append(String.format("<filter type=\"%s\">", this.comparation.equals((Object)Comparation.AND) ? "and" : "or"));
        } else {
            strBuff.append("<filter>");
        }
        for (DynamicsCrmWhereComponent component : this.components) {
            strBuff.append(component.getQueryXml());
        }
        strBuff.append("</filter>");
        return strBuff.toString();
    }

    @Override
    public void release() {
        for (DynamicsCrmWhereComponent component : this.components) {
            component.release();
            Object var2_2 = null;
        }
        this.components.clear();
        this.components = null;
        this.parentComponent = null;
    }

    public static enum Comparation {
        AND,
        OR;

    }
}

