/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.dynamicscrm.query.where;

import java.util.LinkedList;
import java.util.List;

public class DynamicsCrmWhereComposite implements DynamicsCrmWhereComponent {

	public enum Comparation {
		AND,
		OR;
	};
	
	private List<DynamicsCrmWhereComponent> components;
	private DynamicsCrmWhereComposite parentComponent;
	private Comparation comparation;
	
	public DynamicsCrmWhereComposite(DynamicsCrmWhereComposite parentComponent) {
		super();
		this.parentComponent = parentComponent;
		components = new LinkedList<DynamicsCrmWhereComponent>();
		comparation = null;
	}
	
	public void addComponent(DynamicsCrmWhereComponent component) {
		components.add(component);
	}
	
	public DynamicsCrmWhereComposite getParentComposite() {
		return parentComponent;
	}
	
	public Comparation getComparation() {
		return comparation;
	}

	public void setComparation(Comparation comparation) {
		this.comparation = comparation;
	}

	@Override
	public String getQueryXml() {
		StringBuffer strBuff = new StringBuffer();
		
		if (comparation != null) {
			strBuff.append(String.format("<filter type=\"%s\">", (comparation.equals(Comparation.AND) ? "and" : "or")));
		} else {
			strBuff.append("<filter>");
		}
		for (DynamicsCrmWhereComponent component : components) {
			strBuff.append(component.getQueryXml());
		}
		strBuff.append("</filter>");
		
		return strBuff.toString();
	}

	@Override
	public void release() {
		for (DynamicsCrmWhereComponent component : components) {
			component.release();
			component = null;
		}
		components.clear();		
		components = null;
		
		parentComponent = null;
	}

}
