/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.dynamicscrm.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.datacontract.schemas._2004._07.system_collections.KeyValuePairOfstringanyType;

import com.microsoft.schemas._2003._10.serialization.Guid;
import com.microsoft.schemas.xrm._2011.contracts.Entity;
import com.microsoft.schemas.xrm._2011.contracts.EntityCollection;

public class DynamicsCrmUtils {
	
	static public List<Map<String, Object>> mapEntityCollectionToMapCollection(EntityCollection entityCollection)
    {
        List<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        for (Entity entity : entityCollection.getEntities().getEntities())
        {
            entities.add(mapEntityToMap(entity));
        }
        return entities;
    }
	
	static public Map<String, Object> mapEntityToMap(Entity entity)
    {
        Map<String, Object> entityMap = new HashMap<String, Object>();
        for (KeyValuePairOfstringanyType attribute : entity.getAttributes().getKeyValuePairOfstringanyTypes())
        {
            Object value = attribute.getValue();

            if (value instanceof Guid)
            {
                value = ((Guid) value).getValue();
            }

            entityMap.put(attribute.getKey(), value);
        }
        return entityMap;
    }
}
