/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.dynamicscrm.paging;

import com.microsoft.schemas.xrm._2011.contracts.EntityCollection;
import com.microsoft.schemas.xrm._2011.contracts.FetchExpression;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationService;
import com.microsoft.schemas.xrm._2011.contracts.services.IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.module.dynamicscrm.paging.PagingHelper;
import org.mule.module.dynamicscrm.paging.exception.DynamicsCrmPagingException;
import org.mule.module.dynamicscrm.utils.DynamicsCrmUtils;
import org.mule.streaming.PagingDelegate;

public class RetrieveMultipleByQueryPagingDelegate
extends PagingDelegate<Map<String, Object>> {
    private static final Log LOG = LogFactory.getLog(RetrieveMultipleByQueryPagingDelegate.class);
    private IOrganizationService client;
    private EntityCollection lastEntityCollection;
    private String lastQuery;
    private boolean firstPageRequest = true;
    private int itemsPerPage;

    public RetrieveMultipleByQueryPagingDelegate(IOrganizationService client, String query, int itemsPerPage) {
        this.client = client;
        this.lastQuery = query;
        this.itemsPerPage = itemsPerPage;
    }

    public List<Map<String, Object>> getPage() {
        LOG.debug((Object)"Requesting new page");
        if (this.firstPageRequest) {
            this.firstPageRequest = false;
        } else if (PagingHelper.isNativeQueryCurrentPageNumber(this.lastQuery)) {
            int currentPageNumber = PagingHelper.getNativeQueryCurrentPageNumber(this.lastQuery);
            this.lastQuery = PagingHelper.setNativeQueryCurrentPageNumber(this.lastQuery, ++currentPageNumber);
            LOG.debug((Object)("Set page to " + currentPageNumber));
        } else {
            this.lastQuery = PagingHelper.setNativeQueryCurrentPageNumber(this.lastQuery, 2);
            LOG.debug((Object)"Set page to 2");
        }
        if (!PagingHelper.isNativeQueryCurrentPageSize(this.lastQuery) && this.itemsPerPage > 0) {
            this.lastQuery = PagingHelper.setNativeQueryCurrentPageSize(this.lastQuery, this.itemsPerPage);
            LOG.debug((Object)("Set fetchSize (items per page) to " + this.itemsPerPage));
        }
        LOG.debug((Object)("Native Query: " + this.lastQuery));
        FetchExpression query = new FetchExpression();
        query.setQuery(this.lastQuery);
        try {
            this.lastEntityCollection = this.client.retrieveMultiple(query);
        }
        catch (IOrganizationServiceRetrieveMultipleOrganizationServiceFaultFaultFaultMessage e) {
            throw new DynamicsCrmPagingException(e);
        }
        LOG.debug((Object)"Requested new page");
        List<Map<String, Object>> mapEntityCollectionToMapCollection = DynamicsCrmUtils.mapEntityCollectionToMapCollection(this.lastEntityCollection);
        return mapEntityCollectionToMapCollection == null || mapEntityCollectionToMapCollection.isEmpty() ? null : mapEntityCollectionToMapCollection;
    }

    public void close() throws MuleException {
        this.client = null;
        this.lastEntityCollection = null;
        this.lastQuery = null;
    }

    public int getTotalResults() {
        return -1;
    }
}

