/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.dynamicscrm.paging;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;

public class PagingHelper {
		
	static final private Pattern FETCH_ELEMENT = Pattern.compile("<fetch([^>]*)");
	static final private Pattern FETCH_PAGE_NUM_ELEMENT = Pattern.compile("<fetch([^>]*)page=\"([^\"]+)\"");
	static final private Pattern FETCH_PAGE_SIZE_ELEMENT = Pattern.compile("<fetch([^>]*)count=\"([^\"]+)\"");
	
	static public int getNativeQueryCurrentPageNumber(String nativeQuery) {
		if (StringUtils.isEmpty(nativeQuery)) {
			return -1;
		}
		
		Matcher matcher = FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery);
		if (matcher.find()) {
			return Integer.parseInt(matcher.group(2));
		} else {
			return 1;
		}
	}
	
	static public String setNativeQueryCurrentPageNumber(String nativeQuery, int page) {
		if (StringUtils.isEmpty(nativeQuery)) {
			return null;
		}
		
		// If the query already have a defined page number
		if (isNativeQueryCurrentPageNumber(nativeQuery)) { 
			Matcher matcher = FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery);
			matcher.find(); // To be able to use group we must call find first
			return matcher.replaceFirst(String.format("<fetch%spage=\"%d\"", matcher.group(1), page));
		} else {
			Matcher matcher = FETCH_ELEMENT.matcher(nativeQuery);
			return matcher.replaceFirst(String.format("<fetch%s page=\"%d\"", matcher.find() ? matcher.group(1) : "", page));
		}
	}
	
	static public boolean isNativeQueryCurrentPageNumber(String nativeQuery) {
		if (StringUtils.isEmpty(nativeQuery)) {
			return false;
		}
		
		return FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery).find();
	}
	
	static public int getNativeQueryCurrentPageSize(String nativeQuery) {
		if (StringUtils.isEmpty(nativeQuery)) {
			return -1;
		}
		
		Matcher matcher = FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery);
		if (matcher.find()) {
			return Integer.parseInt(matcher.group(2));
		} else {
			return 1;
		}
	}
	
	static public String setNativeQueryCurrentPageSize(String nativeQuery, int pageSize) {
		if (StringUtils.isEmpty(nativeQuery)) {
			return null;
		}
		
		// If the query already have a defined page number
		if (isNativeQueryCurrentPageSize(nativeQuery)) { 
			Matcher matcher = FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery);
			matcher.find(); // To be able to use group we must call find first
			return matcher.replaceFirst(String.format("<fetch%scount=\"%d\"", matcher.group(1), pageSize));
		} else {
			Matcher matcher = FETCH_ELEMENT.matcher(nativeQuery);
			return matcher.replaceFirst(String.format("<fetch%s count=\"%d\"", matcher.find() ? matcher.group(1) : "", pageSize));
		}
	}
	
	static public boolean isNativeQueryCurrentPageSize(String nativeQuery) {
		if (StringUtils.isEmpty(nativeQuery)) {
			return false;
		}
		
		return FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery).find();
	}
}
