/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.dynamicscrm.paging;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PagingHelper {
    private static final Pattern FETCH_ELEMENT = Pattern.compile("<fetch([^>]*)");
    private static final Pattern FETCH_PAGE_NUM_ELEMENT = Pattern.compile("<fetch([^>]*)page=\"([^\"]+)\"");
    private static final Pattern FETCH_PAGE_SIZE_ELEMENT = Pattern.compile("<fetch([^>]*)count=\"([^\"]+)\"");

    public static int getNativeQueryCurrentPageNumber(String nativeQuery) {
        if (StringUtils.isEmpty((String)nativeQuery)) {
            return -1;
        }
        Matcher matcher = FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 1;
    }

    public static String setNativeQueryCurrentPageNumber(String nativeQuery, int page) {
        if (StringUtils.isEmpty((String)nativeQuery)) {
            return null;
        }
        if (PagingHelper.isNativeQueryCurrentPageNumber(nativeQuery)) {
            Matcher matcher = FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery);
            matcher.find();
            return matcher.replaceFirst(String.format("<fetch%spage=\"%d\"", matcher.group(1), page));
        }
        Matcher matcher = FETCH_ELEMENT.matcher(nativeQuery);
        return matcher.replaceFirst(String.format("<fetch%s page=\"%d\"", matcher.find() ? matcher.group(1) : "", page));
    }

    public static boolean isNativeQueryCurrentPageNumber(String nativeQuery) {
        if (StringUtils.isEmpty((String)nativeQuery)) {
            return false;
        }
        return FETCH_PAGE_NUM_ELEMENT.matcher(nativeQuery).find();
    }

    public static int getNativeQueryCurrentPageSize(String nativeQuery) {
        if (StringUtils.isEmpty((String)nativeQuery)) {
            return -1;
        }
        Matcher matcher = FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 1;
    }

    public static String setNativeQueryCurrentPageSize(String nativeQuery, int pageSize) {
        if (StringUtils.isEmpty((String)nativeQuery)) {
            return null;
        }
        if (PagingHelper.isNativeQueryCurrentPageSize(nativeQuery)) {
            Matcher matcher = FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery);
            matcher.find();
            return matcher.replaceFirst(String.format("<fetch%scount=\"%d\"", matcher.group(1), pageSize));
        }
        Matcher matcher = FETCH_ELEMENT.matcher(nativeQuery);
        return matcher.replaceFirst(String.format("<fetch%s count=\"%d\"", matcher.find() ? matcher.group(1) : "", pageSize));
    }

    public static boolean isNativeQueryCurrentPageSize(String nativeQuery) {
        if (StringUtils.isEmpty((String)nativeQuery)) {
            return false;
        }
        return FETCH_PAGE_SIZE_ELEMENT.matcher(nativeQuery).find();
    }
}

